/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.client.gui.action.components;

import com.daqem.arc.Arc;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.sprite.SpriteComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import com.daqem.uilib.gui.component.text.multiline.MultiLineTextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ScrollItemComponent
extends SpriteComponent {
    private static final int PADDING = 4;
    private static final int TEXT_SPACING = 2;
    private static final int WIDTH = 152;
    private final Component description;

    public ScrollItemComponent(Component name, Component description) {
        super(0, 0, 152, 0, Arc.getId("item_background"));
        this.description = description;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        TruncatedTextComponent nameText = new TruncatedTextComponent(4, 4, 144, name);
        MultiLineTextComponent descriptionText = new MultiLineTextComponent(4, 4 + lineHeight + 2, 144, description, -11184811);
        this.addComponent((IComponent)nameText);
        this.addComponent((IComponent)descriptionText);
        this.setHeight(4 + lineHeight + 2 + descriptionText.getLines().size() * lineHeight + 4);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        if (this.getRectangle().containsPoint(mouseX, mouseY)) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, Language.getInstance().getVisualOrder(List.of(this.description)), mouseX, mouseY);
        }
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getTotalX(), this.getTotalY(), this.getWidth(), this.getHeight());
    }
}

