/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInHandCondition
extends AbstractCondition {
    private final ItemStack itemStack;
    private final InteractionHand hand;

    public ItemInHandCondition(boolean inverted, ItemStack itemStack, InteractionHand hand) {
        super(inverted);
        this.itemStack = itemStack;
        this.hand = hand;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.itemStack.getHoverName(), this.hand.name().toLowerCase().replace("_", " "));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        Player player = actionData.getPlayer().arc$getPlayer();
        Item targetItem = this.itemStack.getItem();
        if (this.hand == null) {
            return player.getMainHandItem().getItem() == targetItem || player.getOffhandItem().getItem() == targetItem;
        }
        return player.getItemInHand(this.hand).getItem() == targetItem;
    }

    public IConditionType<?> getType() {
        return ConditionType.ITEM_IN_HAND;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static class Serializer
    implements IConditionSerializer<ItemInHandCondition> {
        @Override
        public ItemInHandCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new ItemInHandCondition(inverted, this.getItemStack(jsonObject.get("item")), this.getOptionalHand(jsonObject, "hand"));
        }

        @Override
        public ItemInHandCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            InteractionHand hand = friendlyByteBuf.readBoolean() ? (InteractionHand)friendlyByteBuf.readEnum(InteractionHand.class) : null;
            return new ItemInHandCondition(inverted, itemStack, hand);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ItemInHandCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)type.itemStack);
            friendlyByteBuf.writeBoolean(type.hand != null);
            if (type.hand != null) {
                friendlyByteBuf.writeEnum((Enum)type.hand);
            }
        }
    }
}

