/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.effect;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class EffectAmplifierAdditionReward
extends AbstractReward {
    private final int addition;

    public EffectAmplifierAdditionReward(double chance, int priority, int addition) {
        super(chance, priority);
        this.addition = addition;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.addition);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        Player player;
        MobEffectInstance effect = actionData.getData(ActionDataType.MOB_EFFECT_INSTANCE);
        if (effect != null && (player = actionData.getPlayer().arc$getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), Mth.floor((float)(effect.getAmplifier() + this.addition)), effect.isAmbient(), effect.isVisible());
            player2.addEffect(newEffect, (Entity)new ServerPlayer(Objects.requireNonNull(player2.getServer()), player2.level(), new GameProfile(UUID.randomUUID(), "a"), player2.clientInformation()));
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.EFFECT_AMPLIFIER_ADDITION;
    }

    public int getAddition() {
        return this.addition;
    }

    public static class Serializer
    implements IRewardSerializer<EffectAmplifierAdditionReward> {
        @Override
        public EffectAmplifierAdditionReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new EffectAmplifierAdditionReward(chance, priority, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"addition"));
        }

        @Override
        public EffectAmplifierAdditionReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new EffectAmplifierAdditionReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, EffectAmplifierAdditionReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeInt(type.addition);
        }
    }
}

