/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.experience;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;

public class ExpMultiplierReward
extends AbstractReward {
    private final int multiplier;

    public ExpMultiplierReward(double chance, int priority, int multiplier) {
        super(chance, priority);
        this.multiplier = multiplier;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.multiplier);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        BlockPos blockPos;
        Integer exp;
        Level level = actionData.getData(ActionDataType.WORLD);
        if (level == null) {
            level = actionData.getPlayer().arc$getLevel();
        }
        if (level != null && (exp = actionData.getData(ActionDataType.EXP_DROP)) != null && exp * this.multiplier - exp > 0 && (blockPos = actionData.getData(ActionDataType.BLOCK_POSITION)) != null) {
            level.addFreshEntity((Entity)new ExperienceOrb(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), exp * this.multiplier - exp));
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.EXP_MULTIPLIER;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public static class Serializer
    implements IRewardSerializer<ExpMultiplierReward> {
        @Override
        public ExpMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new ExpMultiplierReward(chance, priority, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"multiplier"));
        }

        @Override
        public ExpMultiplierReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new ExpMultiplierReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ExpMultiplierReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeInt(type.multiplier);
        }
    }
}

