/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.world;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DropItemReward
extends AbstractReward {
    private final ItemStack itemStack;

    public DropItemReward(double chance, int priority, ItemStack itemStack) {
        super(chance, priority);
        this.itemStack = itemStack;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.itemStack.getCount(), this.itemStack.getHoverName());
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        block7: {
            BlockPos pos = actionData.getData(ActionDataType.BLOCK_POSITION);
            if (pos == null) break block7;
            Level level = actionData.getData(ActionDataType.WORLD);
            if (level == null) {
                level = actionData.getPlayer().arc$getLevel();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.itemStack.isEmpty()) {
                    for (int i = 0; i < this.itemStack.getCount(); ++i) {
                        ItemEntity entity = new ItemEntity((Level)serverLevel, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.itemStack.copy());
                        entity.setDefaultPickUpDelay();
                        serverLevel.addFreshEntity((Entity)entity);
                    }
                } else {
                    BlockState state = actionData.getData(ActionDataType.BLOCK_STATE);
                    if (state != null) {
                        List drops = state.getDrops(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)actionData.getPlayer().arc$getPlayer().getMainHandItem()).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.THIS_ENTITY, (Object)actionData.getPlayer().arc$getPlayer()));
                        for (int i = 0; i < this.itemStack.getCount(); ++i) {
                            ItemStack randomDrop = (ItemStack)drops.get(serverLevel.random.nextInt(drops.size()));
                            ItemEntity entity = new ItemEntity((Level)serverLevel, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), randomDrop);
                            entity.setDefaultPickUpDelay();
                            serverLevel.addFreshEntity((Entity)entity);
                        }
                    }
                }
            }
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.DROP_ITEM;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public static class Serializer
    implements IRewardSerializer<DropItemReward> {
        @Override
        public DropItemReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new DropItemReward(chance, priority, this.getItemStack(jsonObject.get("item")));
        }

        @Override
        public DropItemReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new DropItemReward(chance, priority, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf));
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, DropItemReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)type.itemStack);
        }
    }
}

