/*
 * Decompiled with CFR 0.152.
 */
package dev.nogard.meganim.commands;

import com.ticxo.modelengine.api.model.ModeledEntity;
import dev.nogard.meganim.MEGAnim;
import dev.nogard.meganim.util.AnimationPlayer;
import dev.nogard.meganim.util.EntityTargeter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MEGAnimCommandExecutor
implements CommandExecutor {
    private final MEGAnim plugin;
    private final EntityTargeter targeter;
    private final AnimationPlayer animationPlayer;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public MEGAnimCommandExecutor(MEGAnim plugin) {
        this.plugin = plugin;
        this.targeter = new EntityTargeter(plugin);
        this.animationPlayer = new AnimationPlayer(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean success;
        ModeledEntity target;
        Location sourceLocation;
        Player player = null;
        boolean isPlayer = false;
        if (sender instanceof Player) {
            player = (Player)sender;
            sourceLocation = player.getLocation();
            isPlayer = true;
        } else if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            sourceLocation = block.getBlock().getLocation();
        } else {
            sender.sendMessage("This command can only be used by players or command blocks!");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("meganim.reload")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            this.plugin.getConfigManager().reload();
            sender.sendMessage(this.plugin.getConfigManager().getMessage("config-reloaded"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("info")) {
            if (!sender.hasPermission("meganim.info")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            if (!isPlayer) {
                sender.sendMessage("Info command requires a player!");
                return true;
            }
            return this.handleInfoCommand(player, args);
        }
        if (subCommand.equalsIgnoreCase("list")) {
            if (!sender.hasPermission("meganim.list")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            if (!isPlayer) {
                sender.sendMessage("List command requires a player!");
                return true;
            }
            return this.handleListCommand(player, args);
        }
        if (subCommand.equalsIgnoreCase("stop")) {
            if (!sender.hasPermission("meganim.stop")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            return this.handleStopCommand(sender, sourceLocation, player, isPlayer, args);
        }
        if (!subCommand.equalsIgnoreCase("play")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (!sender.hasPermission("meganim.play")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (isPlayer && !this.checkCooldown(player)) {
            int cooldown = this.plugin.getConfigManager().getCooldown();
            long remaining = (this.cooldowns.get(player.getUniqueId()) + (long)cooldown * 1000L - System.currentTimeMillis()) / 1000L;
            sender.sendMessage(this.plugin.getConfigManager().getMessage("cooldown", Map.of("time", String.valueOf(remaining))));
            return true;
        }
        String animationName = args[1];
        if (this.plugin.getConfigManager().getBlacklistedAnimations().contains(animationName)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-blacklisted"));
            return true;
        }
        String mode = this.plugin.getConfigManager().getAnimationMode();
        int argOffset = 0;
        if (args.length >= 3 && (args[2].equalsIgnoreCase("single") || args[2].equalsIgnoreCase("multiple"))) {
            mode = args[2].toLowerCase();
            argOffset = 1;
        }
        boolean stopFirst = mode.equals("single");
        if (args.length >= 4 + argOffset && args[2 + argOffset].equalsIgnoreCase("uuid")) {
            boolean success2;
            UUID uuid;
            if (!sender.hasPermission("meganim.play.uuid")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            try {
                uuid = UUID.fromString(args[3 + argOffset]);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            ModeledEntity target2 = this.targeter.getUuidTarget(uuid);
            if (target2 == null) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            boolean hasAnimation = target2.getModels().values().stream().anyMatch(model -> model.getBlueprint().getAnimations().containsKey(animationName));
            if (!hasAnimation) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-not-found", Map.of("animation", animationName)));
                return true;
            }
            if (stopFirst) {
                this.animationPlayer.stopAnimations(target2);
            }
            if (success2 = this.animationPlayer.playAnimation(target2, animationName)) {
                if (isPlayer) {
                    this.applyCooldown(player);
                }
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-played", Map.of("animation", animationName, "count", "1")));
            }
            return true;
        }
        if (args.length >= 4 + argOffset && (args[2 + argOffset].equalsIgnoreCase("nametag") || args[2 + argOffset].equalsIgnoreCase("name"))) {
            List<ModeledEntity> targets;
            if (!sender.hasPermission("meganim.play.nametag")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            String nametag = args[3 + argOffset];
            double radius = this.plugin.getConfigManager().getNametagRadius();
            if (args.length >= 5 + argOffset) {
                try {
                    radius = Double.parseDouble(args[4 + argOffset]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            if ((targets = this.targeter.getNametagTargets(sourceLocation, nametag, radius)).isEmpty()) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            int successCount = 0;
            for (ModeledEntity target3 : targets) {
                boolean hasAnimation = target3.getModels().values().stream().anyMatch(model -> model.getBlueprint().getAnimations().containsKey(animationName));
                if (!hasAnimation) continue;
                if (stopFirst) {
                    this.animationPlayer.stopAnimations(target3);
                }
                if (!this.animationPlayer.playAnimation(target3, animationName)) continue;
                ++successCount;
            }
            if (successCount > 0) {
                if (isPlayer) {
                    this.applyCooldown(player);
                }
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-played", Map.of("animation", animationName, "count", String.valueOf(successCount))));
            } else {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-not-found", Map.of("animation", animationName)));
            }
            return true;
        }
        if (args.length >= 4 + argOffset && args[2 + argOffset].equalsIgnoreCase("model")) {
            List<ModeledEntity> targets;
            if (!sender.hasPermission("meganim.play.model")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            String modelId = args[3 + argOffset];
            if (this.plugin.getConfigManager().getBlacklistedModels().contains(modelId)) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("model-blacklisted"));
                return true;
            }
            double radius = this.plugin.getConfigManager().getModelRadius();
            if (args.length >= 5 + argOffset) {
                try {
                    radius = Double.parseDouble(args[4 + argOffset]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            if ((targets = this.targeter.getModelIdTargets(sourceLocation, modelId, radius)).isEmpty()) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            int successCount = 0;
            for (ModeledEntity target4 : targets) {
                boolean hasAnimation = target4.getModels().values().stream().anyMatch(model -> model.getBlueprint().getAnimations().containsKey(animationName));
                if (!hasAnimation) continue;
                if (stopFirst) {
                    this.animationPlayer.stopAnimations(target4);
                }
                if (!this.animationPlayer.playAnimation(target4, animationName)) continue;
                ++successCount;
            }
            if (successCount > 0) {
                if (isPlayer) {
                    this.applyCooldown(player);
                }
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-played", Map.of("animation", animationName, "count", String.valueOf(successCount))));
            } else {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-not-found", Map.of("animation", animationName)));
            }
            return true;
        }
        if (args.length >= 3 + argOffset && args[2 + argOffset].equalsIgnoreCase("nearest")) {
            if (!sender.hasPermission("meganim.play.nearest")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            double radius = this.plugin.getConfigManager().getNearestRadius();
            if (args.length >= 4 + argOffset) {
                try {
                    radius = Double.parseDouble(args[3 + argOffset]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            target = this.targeter.getNearestTarget(sourceLocation, radius);
        } else {
            if (!isPlayer) {
                sender.sendMessage("Raycast targeting requires a player! Use 'nearest', 'model', 'nametag', or 'uuid' targeting.");
                return true;
            }
            target = this.targeter.getRaycastTarget(player);
        }
        if (target == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
            return true;
        }
        boolean hasAnimation = target.getModels().values().stream().anyMatch(model -> model.getBlueprint().getAnimations().containsKey(animationName));
        if (!hasAnimation) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-not-found", Map.of("animation", animationName)));
            return true;
        }
        if (stopFirst) {
            this.animationPlayer.stopAnimations(target);
        }
        if (success = this.animationPlayer.playAnimation(target, animationName)) {
            if (isPlayer) {
                this.applyCooldown(player);
            }
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-played", Map.of("animation", animationName, "count", "1")));
        }
        return true;
    }

    private boolean handleStopCommand(CommandSender sender, Location sourceLocation, Player player, boolean isPlayer, String[] args) {
        if (args.length >= 3 && args[1].equalsIgnoreCase("uuid")) {
            UUID uuid;
            if (!sender.hasPermission("meganim.stop.uuid") && sender instanceof Player) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            try {
                uuid = UUID.fromString(args[2]);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-uuid"));
                return true;
            }
            ModeledEntity target = this.targeter.getUuidTarget(uuid);
            if (target == null) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            this.animationPlayer.stopAnimations(target);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-stopped", Map.of("count", "1")));
            return true;
        }
        if (args.length >= 3 && (args[1].equalsIgnoreCase("nametag") || args[1].equalsIgnoreCase("name"))) {
            List<ModeledEntity> targets;
            if (!sender.hasPermission("meganim.stop.nametag") && sender instanceof Player) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            String nametag = args[2];
            double radius = this.plugin.getConfigManager().getNametagRadius();
            if (args.length >= 4) {
                try {
                    radius = Double.parseDouble(args[3]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            if ((targets = this.targeter.getNametagTargets(sourceLocation, nametag, radius)).isEmpty()) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            for (ModeledEntity target : targets) {
                this.animationPlayer.stopAnimations(target);
            }
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-stopped", Map.of("count", String.valueOf(targets.size()))));
            return true;
        }
        if (args.length >= 3 && args[1].equalsIgnoreCase("model")) {
            List<ModeledEntity> targets;
            if (!sender.hasPermission("meganim.stop.model") && sender instanceof Player) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            String modelId = args[2];
            double radius = this.plugin.getConfigManager().getModelRadius();
            if (args.length >= 4) {
                try {
                    radius = Double.parseDouble(args[3]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            if ((targets = this.targeter.getModelIdTargets(sourceLocation, modelId, radius)).isEmpty()) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            for (ModeledEntity target : targets) {
                this.animationPlayer.stopAnimations(target);
            }
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-stopped", Map.of("count", String.valueOf(targets.size()))));
            return true;
        }
        if (args.length >= 2 && args[1].equalsIgnoreCase("nearest")) {
            ModeledEntity target;
            if (!sender.hasPermission("meganim.stop.nearest") && sender instanceof Player) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                return true;
            }
            double radius = this.plugin.getConfigManager().getNearestRadius();
            if (args.length >= 3) {
                try {
                    radius = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                double maxRadius = this.plugin.getConfigManager().getMaxRadius();
                if (radius < 1.0 || radius > maxRadius) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-radius", Map.of("max", String.valueOf((int)maxRadius))));
                    return true;
                }
            }
            if ((target = this.targeter.getNearestTarget(sourceLocation, radius)) == null) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
                return true;
            }
            this.animationPlayer.stopAnimations(target);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-stopped", Map.of("count", "1")));
            return true;
        }
        if (!isPlayer) {
            sender.sendMessage("Raycast targeting requires a player! Use 'nearest', 'model', 'nametag', or 'uuid' targeting.");
            return true;
        }
        ModeledEntity target = this.targeter.getRaycastTarget(player);
        if (target == null) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
            return true;
        }
        this.animationPlayer.stopAnimations(target);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("animation-stopped", Map.of("count", "1")));
        return true;
    }

    private boolean handleListCommand(Player player, String[] args) {
        ModeledEntity target = this.targeter.getRaycastTarget(player);
        if (target == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
            return true;
        }
        Set animations = target.getModels().values().stream().flatMap(model -> model.getBlueprint().getAnimations().keySet().stream()).collect(Collectors.toSet());
        player.sendMessage(this.plugin.getConfigManager().getMessage("animations-list", Map.of("animations", String.join((CharSequence)", ", animations))));
        return true;
    }

    private boolean handleInfoCommand(Player player, String[] args) {
        ModeledEntity target = this.targeter.getRaycastTarget(player);
        if (target == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("no-target"));
            return true;
        }
        String models = target.getModels().values().stream().map(model -> model.getBlueprint().getName()).collect(Collectors.joining(", "));
        int animCount = (int)target.getModels().values().stream().flatMap(model -> model.getBlueprint().getAnimations().keySet().stream()).distinct().count();
        player.sendMessage(this.plugin.getConfigManager().getMessage("entity-info", Map.of("uuid", ((Entity)target.getBase().getOriginal()).getUniqueId().toString(), "models", models, "count", String.valueOf(animCount))));
        return true;
    }

    private boolean checkCooldown(Player player) {
        int cooldown = this.plugin.getConfigManager().getCooldown();
        if (cooldown == 0) {
            return true;
        }
        if (this.cooldowns.containsKey(player.getUniqueId())) {
            long lastUse = this.cooldowns.get(player.getUniqueId());
            long now = System.currentTimeMillis();
            return now - lastUse >= (long)cooldown * 1000L;
        }
        return true;
    }

    private void applyCooldown(Player player) {
        int cooldown = this.plugin.getConfigManager().getCooldown();
        if (cooldown > 0) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }
}

