/*
 * Decompiled with CFR 0.152.
 */
package dev.nogard.meganim.commands;

import com.ticxo.modelengine.api.model.ModeledEntity;
import dev.nogard.meganim.MEGAnim;
import dev.nogard.meganim.util.EntityTargeter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MEGAnimTabCompleter
implements TabCompleter {
    private final MEGAnim plugin;
    private final EntityTargeter targeter;

    public MEGAnimTabCompleter(MEGAnim plugin) {
        this.plugin = plugin;
        this.targeter = new EntityTargeter(plugin);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String arg2;
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            return Arrays.asList("play", "stop", "list", "info", "reload").stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("reload")) {
            return new ArrayList<String>();
        }
        if (args.length == 2) {
            if (subCommand.equals("play")) {
                ModeledEntity target = this.targeter.getRaycastTarget(player);
                if (target != null) {
                    return target.getModels().values().stream().flatMap(model -> model.getBlueprint().getAnimations().keySet().stream()).distinct().filter(anim -> anim.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
                return new ArrayList<String>();
            }
            return Arrays.asList("nearest", "model", "name", "nametag", "uuid").stream().filter(mode -> mode.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            if (subCommand.equals("play")) {
                return Arrays.asList("single", "multiple", "nearest", "model", "name", "nametag", "uuid").stream().filter(mode -> mode.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }
        if (args.length == 4 && subCommand.equals("play")) {
            arg2 = args[2].toLowerCase();
            if (arg2.equals("single") || arg2.equals("multiple")) {
                return Arrays.asList("nearest", "model", "name", "nametag", "uuid").stream().filter(mode -> mode.toLowerCase().startsWith(args[3].toLowerCase())).collect(Collectors.toList());
            }
            if (arg2.equals("nearest") || arg2.equals("model") || arg2.equals("name") || arg2.equals("nametag")) {
                return Arrays.asList("10", "20", "50");
            }
        }
        if (args.length == 5 && subCommand.equals("play")) {
            arg2 = args[2].toLowerCase();
            String arg3 = args[3].toLowerCase();
            if ((arg2.equals("single") || arg2.equals("multiple")) && (arg3.equals("nearest") || arg3.equals("model") || arg3.equals("name") || arg3.equals("nametag"))) {
                return Arrays.asList("10", "20", "50");
            }
        }
        return new ArrayList<String>();
    }
}

