/*
 * Decompiled with CFR 0.152.
 */
package dev.nogard.meganim.config;

import dev.nogard.meganim.MEGAnim;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final MEGAnim plugin;
    private FileConfiguration config;

    public ConfigManager(MEGAnim plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public double getRaycastRange() {
        return this.config.getDouble("defaults.raycast-range", 15.0);
    }

    public double getNearestRadius() {
        return this.config.getDouble("defaults.nearest-radius", 10.0);
    }

    public double getModelRadius() {
        return this.config.getDouble("defaults.model-radius", 50.0);
    }

    public double getNametagRadius() {
        return this.config.getDouble("defaults.nametag-radius", 50.0);
    }

    public double getAnimationSpeed() {
        return this.config.getDouble("defaults.animation-speed", 1.0);
    }

    public double getAnimationLerp() {
        return this.config.getDouble("defaults.animation-lerp", 0.2);
    }

    public boolean getAnimationLoop() {
        return this.config.getBoolean("defaults.animation-loop", false);
    }

    public String getAnimationMode() {
        return this.config.getString("defaults.animation-mode", "multiple").toLowerCase();
    }

    public double getMaxRadius() {
        return this.config.getDouble("restrictions.max-radius", 100.0);
    }

    public int getCooldown() {
        return this.config.getInt("restrictions.cooldown", 0);
    }

    public List<String> getBlacklistedAnimations() {
        return this.config.getStringList("restrictions.blacklisted-animations");
    }

    public List<String> getBlacklistedModels() {
        return this.config.getStringList("restrictions.blacklisted-models");
    }

    public String getMessage(String key) {
        String prefix = this.config.getString("messages.prefix", "&8[&6MEGAnim&8]&r");
        String message = this.config.getString("messages." + key, "&cMessage not found: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + " " + message));
    }

    public String getMessage(String key, Map<String, String> replacements) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    public boolean isDebug() {
        return this.config.getBoolean("debug", false);
    }

    public void debug(String message) {
        if (this.isDebug()) {
            this.plugin.getLogger().info("[DEBUG] " + message);
        }
    }
}

