/*
 * Decompiled with CFR 0.152.
 */
package dev.nogard.meganim.util;

import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import dev.nogard.meganim.MEGAnim;

public class AnimationPlayer {
    private final MEGAnim plugin;

    public AnimationPlayer(MEGAnim plugin) {
        this.plugin = plugin;
    }

    public boolean playAnimation(ModeledEntity modeledEntity, String animationName) {
        return this.playAnimation(modeledEntity, animationName, this.plugin.getConfigManager().getAnimationSpeed(), this.plugin.getConfigManager().getAnimationLerp(), this.plugin.getConfigManager().getAnimationLoop());
    }

    public boolean playAnimation(ModeledEntity modeledEntity, String animationName, double speed, double lerp, boolean loop) {
        boolean success = false;
        for (ActiveModel model : modeledEntity.getModels().values()) {
            if (!model.getBlueprint().getAnimations().containsKey(animationName)) continue;
            try {
                model.getAnimationHandler().playAnimation(animationName, speed, lerp, 1.0, loop);
                success = true;
                this.plugin.getConfigManager().debug("Playing animation '" + animationName + "' on model '" + model.getBlueprint().getName() + "'");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to play animation '" + animationName + "' on model '" + model.getBlueprint().getName() + "': " + e.getMessage());
            }
        }
        return success;
    }

    public void stopAnimations(ModeledEntity modeledEntity) {
        for (ActiveModel model : modeledEntity.getModels().values()) {
            try {
                model.getAnimationHandler().forceStopAllAnimations();
                this.plugin.getConfigManager().debug("Stopped animations on model '" + model.getBlueprint().getName() + "'");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to stop animations on model '" + model.getBlueprint().getName() + "': " + e.getMessage());
            }
        }
    }
}

