/*
 * Decompiled with CFR 0.152.
 */
package dev.nogard.meganim.util;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import dev.nogard.meganim.MEGAnim;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class EntityTargeter {
    private final MEGAnim plugin;

    public EntityTargeter(MEGAnim plugin) {
        this.plugin = plugin;
    }

    public ModeledEntity getRaycastTarget(Player player) {
        double range = this.plugin.getConfigManager().getRaycastRange();
        RayTraceResult rayTraceResult = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), range, entity -> entity != player);
        if (rayTraceResult == null || rayTraceResult.getHitEntity() == null) {
            return null;
        }
        return ModelEngineAPI.getModeledEntity((UUID)rayTraceResult.getHitEntity().getUniqueId());
    }

    public ModeledEntity getNearestTarget(Location location, double radius) {
        ArrayList nearbyEntities = new ArrayList(location.getWorld().getNearbyEntities(location, radius, radius, radius));
        ModeledEntity nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double distance;
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((UUID)entity.getUniqueId());
            if (modeledEntity == null || !((distance = location.distance(entity.getLocation())) < nearestDistance)) continue;
            nearest = modeledEntity;
            nearestDistance = distance;
        }
        return nearest;
    }

    public List<ModeledEntity> getModelIdTargets(Location location, String modelId, double radius) {
        ArrayList nearbyEntities = new ArrayList(location.getWorld().getNearbyEntities(location, radius, radius, radius));
        ArrayList<ModeledEntity> targets = new ArrayList<ModeledEntity>();
        for (Entity entity : nearbyEntities) {
            boolean hasModel;
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((UUID)entity.getUniqueId());
            if (modeledEntity == null || !(hasModel = modeledEntity.getModels().values().stream().anyMatch(model -> model.getBlueprint().getName().equalsIgnoreCase(modelId)))) continue;
            targets.add(modeledEntity);
        }
        return targets;
    }

    public List<ModeledEntity> getNametagTargets(Location location, String nametag, double radius) {
        ArrayList nearbyEntities = new ArrayList(location.getWorld().getNearbyEntities(location, radius, radius, radius));
        ArrayList<ModeledEntity> targets = new ArrayList<ModeledEntity>();
        for (Entity entity : nearbyEntities) {
            ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity((UUID)entity.getUniqueId());
            if (modeledEntity == null || entity.getCustomName() == null || !ChatColor.stripColor((String)entity.getCustomName()).equalsIgnoreCase(ChatColor.stripColor((String)nametag))) continue;
            targets.add(modeledEntity);
        }
        return targets;
    }

    public ModeledEntity getUuidTarget(UUID uuid) {
        return ModelEngineAPI.getModeledEntity((UUID)uuid);
    }
}

