/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import me.sunlan.fastreflection.FastConstructor;
import me.sunlan.fastreflection.FastField;
import me.sunlan.fastreflection.FastMember;
import me.sunlan.fastreflection.FastMemberLoader;
import me.sunlan.fastreflection.FastMethod;
import me.sunlan.fastreflection.LazyFastConstructor;
import me.sunlan.fastreflection.LazyFastField;
import me.sunlan.fastreflection.LazyFastMethod;
import me.sunlan.fastreflection.MemberLoadable;

public class FastClass<T> {
    private final Class<T> clazz;
    private final MemberLoadable memberLoader;

    public static <T> FastClass<T> create(Class<T> clazz) {
        return FastClass.create(clazz, FastMemberLoader.getDefaultLoader());
    }

    public static <T> FastClass<T> create(Class<T> clazz, MemberLoadable memberLoader) {
        return new FastClass<T>(clazz, memberLoader);
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    public FastMethod getMethod(String name, Class<?> parameterTypes) throws NoSuchMethodException {
        Method method = this.clazz.getMethod(name, parameterTypes);
        return this.createMethod(method);
    }

    public FastMethod getDeclaredMethod(String name, Class<?> parameterTypes) throws NoSuchMethodException {
        Method method = this.clazz.getDeclaredMethod(name, parameterTypes);
        return this.createMethod(method);
    }

    public FastMethod[] getMethods() {
        Method[] methods = this.clazz.getMethods();
        return this.doGetMethods(methods);
    }

    public FastMethod[] getDeclaredMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        return this.doGetMethods(methods);
    }

    public FastConstructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> constructor = this.clazz.getConstructor(parameterTypes);
        return this.createConstructor(constructor);
    }

    public FastConstructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> constructor = this.clazz.getDeclaredConstructor(parameterTypes);
        return this.createConstructor(constructor);
    }

    public FastConstructor<?>[] getConstructors() {
        Constructor<?>[] constructors = this.clazz.getConstructors();
        return this.doGetConstructors(constructors);
    }

    public FastConstructor<?>[] getDeclaredConstructors() {
        Constructor<?>[] constructors = this.clazz.getDeclaredConstructors();
        return this.doGetConstructors(constructors);
    }

    public FastField getField(String name) throws NoSuchFieldException {
        Field field = this.clazz.getField(name);
        return this.createField(field);
    }

    public FastField getDeclaredField(String name) throws NoSuchFieldException {
        Field field = this.clazz.getDeclaredField(name);
        return this.createField(field);
    }

    public FastField[] getFields() {
        Field[] fields = this.clazz.getFields();
        return this.doGetFields(fields);
    }

    public FastField[] getDeclaredFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        return this.doGetFields(fields);
    }

    public Class<T> getRawClass() {
        return this.clazz;
    }

    private synchronized FastMethod[] doGetMethods(Method[] methods) {
        return (FastMethod[])Arrays.stream(methods).map(method -> new LazyFastMethod(() -> this.createMethod((Method)method))).toArray(FastMethod[]::new);
    }

    private FastConstructor<T>[] doGetConstructors(Constructor<T>[] constructors) {
        return (FastConstructor[])Arrays.stream(constructors).map(constructor -> new LazyFastConstructor(() -> this.createConstructor((Constructor<T>)constructor))).toArray(FastConstructor[]::new);
    }

    private FastField[] doGetFields(Field[] fields) {
        return (FastField[])Arrays.stream(fields).map(field -> new LazyFastField(() -> this.createField((Field)field))).toArray(FastField[]::new);
    }

    private FastConstructor<T> createConstructor(Constructor<T> constructor) {
        return (FastConstructor)this.create(constructor, m -> FastConstructor.create((Constructor)m, this.memberLoader, false));
    }

    private FastField createField(Field field) {
        return (FastField)this.create(field, m -> FastField.create((Field)m, this.memberLoader, false));
    }

    private FastMethod createMethod(Method method) {
        return (FastMethod)this.create(method, m -> FastMethod.create((Method)m, this.memberLoader, false));
    }

    private FastMember create(Member m, Function<? super Member, ? extends FastMember> factory) {
        return factory.apply(m);
    }

    private FastClass(Class<T> clazz, MemberLoadable memberLoader) {
        this.clazz = clazz;
        this.memberLoader = memberLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastClass)) {
            return false;
        }
        FastClass fastClass = (FastClass)o;
        return this.memberLoader == fastClass.memberLoader && this.clazz.equals(fastClass.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.memberLoader);
    }

    public String toString() {
        return this.clazz.toString();
    }
}

