/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection;

import java.lang.reflect.Constructor;
import java.util.Objects;
import me.sunlan.fastreflection.FastClass;
import me.sunlan.fastreflection.FastExecutable;
import me.sunlan.fastreflection.FastMemberLoader;
import me.sunlan.fastreflection.MemberLoadable;
import me.sunlan.fastreflection.generator.FastConstructorGenerator;

public abstract class FastConstructor<T>
extends FastExecutable {
    private final Constructor<T> constructor;
    private final MemberLoadable memberLoader;
    private final FastClass<T> declaringClass;

    FastConstructor() {
        super(null, null);
        this.constructor = null;
        this.memberLoader = null;
        this.declaringClass = null;
    }

    protected FastConstructor(Constructor<T> constructor, MemberLoadable memberLoader) {
        super(constructor, memberLoader);
        this.constructor = constructor;
        this.memberLoader = memberLoader;
        this.declaringClass = FastClass.create(constructor.getDeclaringClass(), memberLoader);
    }

    public abstract Object invoke(Object ... var1) throws Throwable;

    public static <T> FastConstructor<T> create(Constructor<T> constructor) {
        return FastConstructor.create(constructor, false);
    }

    public static <T> FastConstructor<T> create(Constructor<T> constructor, boolean toSetAccessible) {
        return FastConstructor.create(constructor, FastMemberLoader.getDefaultLoader(), toSetAccessible);
    }

    public static <T> FastConstructor<T> create(Constructor<T> constructor, MemberLoadable memberLoader, boolean toSetAccessible) {
        return (FastConstructor)memberLoader.load(FastConstructorGenerator.INSTANCE.generate(constructor, toSetAccessible));
    }

    public FastClass<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.constructor.getName();
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastConstructor)) {
            return false;
        }
        FastConstructor that = (FastConstructor)o;
        return this.constructor.equals(that.constructor) && this.declaringClass.equals(that.declaringClass);
    }

    public int hashCode() {
        return Objects.hash(this.constructor, this.declaringClass);
    }

    public String toString() {
        return this.constructor.toString();
    }
}

