/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import me.sunlan.fastreflection.FastClass;
import me.sunlan.fastreflection.FastFieldGetter;
import me.sunlan.fastreflection.FastFieldSetter;
import me.sunlan.fastreflection.FastMember;
import me.sunlan.fastreflection.FastMemberLoader;
import me.sunlan.fastreflection.MemberLoadable;

public class FastField
implements FastMember {
    private final Field field;
    private final MemberLoadable memberLoader;
    private final FastClass<?> declaringClass;
    private final FastFieldGetter fastFieldGetter;
    private final FastFieldSetter fastFieldSetter;

    protected FastField() {
        this.field = null;
        this.memberLoader = null;
        this.declaringClass = null;
        this.fastFieldGetter = null;
        this.fastFieldSetter = null;
    }

    private FastField(Field field, MemberLoadable memberLoader, FastFieldGetter fastFieldGetter, FastFieldSetter fastFieldSetter) {
        this.field = field;
        this.memberLoader = memberLoader;
        this.declaringClass = FastClass.create(field.getDeclaringClass(), memberLoader);
        this.fastFieldGetter = fastFieldGetter;
        this.fastFieldSetter = fastFieldSetter;
    }

    public static FastField create(Field field) {
        return FastField.create(field, false);
    }

    public static FastField create(Field field, boolean toSetAccessible) {
        return FastField.create(field, FastMemberLoader.getDefaultLoader(), toSetAccessible);
    }

    public static FastField create(Field field, MemberLoadable memberLoader, boolean toSetAccessible) {
        FastFieldGetter fastFieldGetter = FastFieldGetter.create(field, memberLoader, toSetAccessible);
        FastFieldSetter fastFieldSetter = Modifier.isFinal(field.getModifiers()) ? null : FastFieldSetter.create(field, memberLoader, toSetAccessible);
        return new FastField(field, memberLoader, fastFieldGetter, fastFieldSetter);
    }

    public Object get(Object obj) throws Throwable {
        return this.fastFieldGetter.get(obj);
    }

    public void set(Object obj, Object value) throws Throwable {
        if (null == this.fastFieldSetter) {
            throw new IllegalAccessException("unexpected set of a final field: " + this.field.toString());
        }
        this.fastFieldSetter.set(obj, value);
    }

    @Override
    public FastClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastField)) {
            return false;
        }
        FastField fastField = (FastField)o;
        return this.field.equals(fastField.field) && this.declaringClass.equals(fastField.declaringClass);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.declaringClass);
    }

    public String toString() {
        return this.field.toString();
    }
}

