/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.sunlan.fastreflection.FastInstantiationException;
import me.sunlan.fastreflection.FastMember;
import me.sunlan.fastreflection.MemberLoadable;
import me.sunlan.fastreflection.generator.MemberData;

public class FastMemberLoader
extends ClassLoader
implements MemberLoadable {
    private static final FastMemberLoader DEFAULT_LOADER = new FastMemberLoader();
    private final Map<String, FastMember> loadedFastMemberCache = new ConcurrentHashMap<String, FastMember>();

    public static FastMemberLoader getDefaultLoader() {
        return DEFAULT_LOADER;
    }

    public FastMemberLoader() {
        this(FastMemberLoader.class.getClassLoader());
    }

    public FastMemberLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public <T extends FastMember> T load(MemberData memberData) {
        String fastMemberClassName = memberData.getName();
        FastMember result = this.loadedFastMemberCache.computeIfAbsent(fastMemberClassName, m -> {
            Class<?> fastMemberClass = this.defineClass(fastMemberClassName, memberData.getBytes());
            try {
                Member member = memberData.getMember();
                return (FastMember)fastMemberClass.getConstructor(member.getClass(), MemberLoadable.class).newInstance(member, this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FastInstantiationException(e);
            }
            catch (ExceptionInInitializerError e) {
                throw (FastInstantiationException)e.getCause();
            }
        });
        return (T)result;
    }

    private Class<?> defineClass(String className, byte[] bytes) {
        Class<?> result = this.findLoadedClass(className);
        if (null != result) {
            return result;
        }
        return super.defineClass(className, bytes, 0, bytes.length);
    }
}

