/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.MethodVisitor;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.Type;

class AsmUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;

    public static void cast(MethodVisitor mv, Class<?> parameterType) {
        if (parameterType.isPrimitive()) {
            String wrapperInternalName = Type.getInternalName(AsmUtils.getWrapper(parameterType));
            mv.visitTypeInsn(192, wrapperInternalName);
            mv.visitMethodInsn(182, wrapperInternalName, parameterType.getSimpleName() + "Value", "()" + Type.getType(parameterType), false);
        } else {
            mv.visitTypeInsn(192, Type.getInternalName(parameterType));
        }
    }

    public static void doReturn(MethodVisitor mv, Class<?> returnType) {
        if (Void.TYPE == returnType) {
            mv.visitInsn(1);
        } else if (returnType.isPrimitive()) {
            Class<?> returnTypeWrapper = AsmUtils.getWrapper(returnType);
            String valueOfMethodDescriptor = AsmUtils.getMethodDescriptor(returnTypeWrapper, new Class[]{returnType});
            mv.visitMethodInsn(184, Type.getInternalName(returnTypeWrapper), "valueOf", valueOfMethodDescriptor, false);
        }
        mv.visitInsn(176);
    }

    public static void visitLdcTypeInsn(MethodVisitor mv, Class<?> type) {
        if (type.isPrimitive()) {
            mv.visitFieldInsn(178, Type.getInternalName(AsmUtils.getWrapper(type)), "TYPE", "Ljava/lang/Class;");
        } else {
            mv.visitLdcInsn(Type.getObjectType(Type.getInternalName(type)));
        }
    }

    public static Class<?> getWrapper(Class<?> primitiveType) {
        return PRIMITIVES_TO_WRAPPERS.get(primitiveType);
    }

    public static String getMethodDescriptor(Class<?> returnType, Class<?>[] paramTypes) {
        StringJoiner buffer = new StringJoiner("", "(", ")" + Type.getDescriptor(returnType));
        for (Class<?> paramType : paramTypes) {
            buffer.add(Type.getDescriptor(paramType));
        }
        return buffer.toString();
    }

    private AsmUtils() {
    }

    static {
        HashMap<Class<Object>, Class<Void>> m = new HashMap<Class<Object>, Class<Void>>();
        m.put(Boolean.TYPE, Boolean.class);
        m.put(Byte.TYPE, Byte.class);
        m.put(Character.TYPE, Character.class);
        m.put(Double.TYPE, Double.class);
        m.put(Float.TYPE, Float.class);
        m.put(Integer.TYPE, Integer.class);
        m.put(Long.TYPE, Long.class);
        m.put(Short.TYPE, Short.class);
        m.put(Void.TYPE, Void.class);
        PRIMITIVES_TO_WRAPPERS = Collections.unmodifiableMap(m);
    }
}

