/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import me.sunlan.fastreflection.FastConstructor;
import me.sunlan.fastreflection.generator.AsmUtils;
import me.sunlan.fastreflection.generator.EncodingUtils;
import me.sunlan.fastreflection.generator.FastExecutableGenerator;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.MethodVisitor;

public class FastConstructorGenerator
extends FastExecutableGenerator {
    public static final FastConstructorGenerator INSTANCE = new FastConstructorGenerator();

    private FastConstructorGenerator() {
    }

    public Class<FastConstructor> getFastMemberClass() {
        return FastConstructor.class;
    }

    @Override
    public String generateClassName(Member member) {
        return this.getFastMemberClass().getName() + "_" + EncodingUtils.md5(((Constructor)member).toGenericString());
    }

    @Override
    public String getMemberDescriptor() {
        return "Ljava/lang/reflect/Constructor;";
    }

    @Override
    public Class<?> getInvokeMethodReturnType(Member member) {
        return member.getDeclaringClass();
    }

    @Override
    public void visitGetMember(MethodVisitor mv, Member member) {
        boolean isPublic = Modifier.isPublic(member.getModifiers());
        mv.visitMethodInsn(182, "java/lang/Class", isPublic ? "getConstructor" : "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", false);
    }

    @Override
    public Class<?>[] getParameterTypes(Member member) {
        return ((Constructor)member).getParameterTypes();
    }

    @Override
    public void visitFindMethod(MethodVisitor mv, Member member) {
        mv.visitMethodInsn(182, LOOKUP_INTERNAL_NAME, "unreflectConstructor", "(Ljava/lang/reflect/Constructor;)Ljava/lang/invoke/MethodHandle;", false);
    }

    @Override
    public void visitMemberName(MethodVisitor mv, Member member) {
    }

    @Override
    public void visitTargetObject(Member member, MethodVisitor mv) {
    }

    @Override
    public int getArgsIndex() {
        return 1;
    }

    @Override
    public String getInvokeExactMethodDescriptor(Member member, Class<?>[] parameterTypes, Class<?> returnType) {
        return AsmUtils.getMethodDescriptor(returnType, parameterTypes);
    }

    @Override
    public String getInvokeMethodDescriptor() {
        return "([Ljava/lang/Object;)Ljava/lang/Object;";
    }
}

