/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection.generator;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import me.sunlan.fastreflection.AccessibleObjectHelper;
import me.sunlan.fastreflection.FastInstantiationException;
import me.sunlan.fastreflection.MemberLoadable;
import me.sunlan.fastreflection.generator.AsmUtils;
import me.sunlan.fastreflection.generator.FastMemberGenerator;
import me.sunlan.fastreflection.generator.MemberData;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.ClassWriter;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.FieldVisitor;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.Label;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.MethodVisitor;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.Type;

abstract class FastExecutableGenerator
implements FastMemberGenerator {
    private static final int CLASSWRITER_FLAGS = 3;
    private static final int ACC_CLASS = 49;
    private static final int ACC_INNERCLASS = 25;
    private static final int ACC_FIELD = 26;
    private static final int ACC_METHOD = 129;
    private static final String INIT = "<init>";
    private static final String ACCESSIBLEOBJECTHELPER_INTERNAL_NAME = Type.getInternalName(AccessibleObjectHelper.class);
    protected static final String METHODHANDLE_DESCRIPTOR = Type.getDescriptor(MethodHandle.class);
    protected static final String METHODHANDLE_INTERNAL_NAME = Type.getInternalName(MethodHandle.class);
    protected static final String METHODHANDLES_INTERNAL_NAME = Type.getInternalName(MethodHandles.class);
    protected static final String FASTINSTANTIATIONEXCEPTION_INTERNAL_NAME = Type.getInternalName(FastInstantiationException.class);
    protected static final String THROWABLE_INTERNAL_NAME = Type.getInternalName(Throwable.class);
    protected static final String THROWABLE_DESCRIPTOR = Type.getDescriptor(Throwable.class);
    protected static final String MEMBERLOADABLE_DESCRIPTOR = Type.getDescriptor(MemberLoadable.class);
    protected static final String LOOKUP_DESCRIPTOR = Type.getDescriptor(MethodHandles.Lookup.class);
    protected static final String CLASS_INTERNAL_NAME = Type.getInternalName(Class.class);

    FastExecutableGenerator() {
    }

    @Override
    public MemberData generate(Member member, boolean toSetAccessible) {
        ClassWriter classWriter = new ClassWriter(3);
        String className = this.generateClassName(member) + "_" + (toSetAccessible ? "1" : "0");
        String internalClassName = className.replace('.', '/');
        String fastMemberInternalName = Type.getInternalName(this.getFastMemberClass());
        classWriter.visit(52, 49, internalClassName, null, fastMemberInternalName, null);
        this.generateConstantMethodHandleField(classWriter);
        this.generateConstructor(classWriter, fastMemberInternalName);
        Class<?>[] parameterTypes = this.getParameterTypes(member);
        this.generateInvokeMethod(member, classWriter, internalClassName, parameterTypes);
        this.generateStaticBlock(member, classWriter, internalClassName, parameterTypes, toSetAccessible);
        classWriter.visitEnd();
        return new MemberData(member, className, classWriter.toByteArray());
    }

    private void generateStaticBlock(Member member, ClassWriter classWriter, String internalClassName, Class<?>[] parameterTypes, boolean toSetAccessible) {
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        mv.visitTryCatchBlock(label0, label1, label2, THROWABLE_INTERNAL_NAME);
        mv.visitLabel(label0);
        AsmUtils.visitLdcTypeInsn(mv, member.getDeclaringClass());
        this.visitMemberName(mv, member);
        this.visitTypeArray(parameterTypes, mv);
        this.visitGetMember(mv, member);
        mv.visitVarInsn(58, 0);
        if (toSetAccessible) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, ACCESSIBLEOBJECTHELPER_INTERNAL_NAME, "trySetAccessible", "(Ljava/lang/reflect/AccessibleObject;)Z", false);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(184, METHODHANDLES_INTERNAL_NAME, "lookup", "()" + LOOKUP_DESCRIPTOR, false);
        mv.visitVarInsn(25, 0);
        this.visitFindMethod(mv, member);
        mv.visitFieldInsn(179, internalClassName, "METHOD_HANDLE", METHODHANDLE_DESCRIPTOR);
        mv.visitLabel(label1);
        Label label4 = new Label();
        mv.visitJumpInsn(167, label4);
        mv.visitLabel(label2);
        mv.visitVarInsn(58, 1);
        mv.visitTypeInsn(187, FASTINSTANTIATIONEXCEPTION_INTERNAL_NAME);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, FASTINSTANTIATIONEXCEPTION_INTERNAL_NAME, INIT, "(" + THROWABLE_DESCRIPTOR + ")V", false);
        mv.visitInsn(191);
        mv.visitLabel(label4);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateInvokeMethod(Member member, ClassWriter classWriter, String internalClassName, Class<?>[] parameterTypes) {
        MethodVisitor mv = classWriter.visitMethod(129, "invoke", this.getInvokeMethodDescriptor(), null, new String[]{THROWABLE_INTERNAL_NAME});
        mv.visitCode();
        Label label0 = new Label();
        mv.visitLabel(label0);
        mv.visitFieldInsn(178, internalClassName, "METHOD_HANDLE", METHODHANDLE_DESCRIPTOR);
        this.visitTargetObject(member, mv);
        int argsIndex = this.getArgsIndex();
        int n = parameterTypes.length;
        for (int i = 0; i < n; ++i) {
            mv.visitVarInsn(25, argsIndex);
            mv.visitLdcInsn(i);
            mv.visitInsn(50);
            AsmUtils.cast(mv, parameterTypes[i]);
        }
        Class<?> invokeMethodReturnType = this.getInvokeMethodReturnType(member);
        String invokeExactMethodDescriptor = this.getInvokeExactMethodDescriptor(member, parameterTypes, invokeMethodReturnType);
        mv.visitMethodInsn(182, METHODHANDLE_INTERNAL_NAME, "invokeExact", invokeExactMethodDescriptor, false);
        AsmUtils.doReturn(mv, invokeMethodReturnType);
        Label label3 = new Label();
        mv.visitLabel(label3);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateConstructor(ClassWriter classWriter, String fastMemberInternalName) {
        String constructorDescriptor = "(" + this.getMemberDescriptor() + MEMBERLOADABLE_DESCRIPTOR + ")V";
        MethodVisitor mv = classWriter.visitMethod(1, INIT, constructorDescriptor, null, null);
        mv.visitCode();
        Label label0 = new Label();
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, fastMemberInternalName, INIT, constructorDescriptor, false);
        mv.visitInsn(177);
        Label label2 = new Label();
        mv.visitLabel(label2);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateConstantMethodHandleField(ClassWriter classWriter) {
        FieldVisitor fv = classWriter.visitField(26, "METHOD_HANDLE", METHODHANDLE_DESCRIPTOR, null, null);
        fv.visitEnd();
    }

    protected void visitTypeArray(Class<?>[] parameterTypes, MethodVisitor mv) {
        mv.visitLdcInsn(parameterTypes.length);
        mv.visitTypeInsn(189, CLASS_INTERNAL_NAME);
        int n = parameterTypes.length;
        for (int i = 0; i < n; ++i) {
            mv.visitInsn(89);
            mv.visitLdcInsn(i);
            AsmUtils.visitLdcTypeInsn(mv, parameterTypes[i]);
            mv.visitInsn(83);
        }
    }
}

