/*
 * Decompiled with CFR 0.152.
 */
package me.sunlan.fastreflection.generator;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;
import me.sunlan.fastreflection.FastMethod;
import me.sunlan.fastreflection.generator.AsmUtils;
import me.sunlan.fastreflection.generator.EncodingUtils;
import me.sunlan.fastreflection.generator.FastExecutableGenerator;
import me.sunlan.fastreflection.shaded.org.objectweb.asm.MethodVisitor;

public class FastMethodGenerator
extends FastExecutableGenerator {
    public static final FastMethodGenerator INSTANCE = new FastMethodGenerator();

    protected FastMethodGenerator() {
    }

    public Class<? extends FastMethod> getFastMemberClass() {
        return FastMethod.class;
    }

    @Override
    public String generateClassName(Member member) {
        return this.getFastMemberClass().getName() + "_" + EncodingUtils.md5(((Method)member).toGenericString());
    }

    @Override
    public Class<?> getInvokeMethodReturnType(Member member) {
        return ((Method)member).getReturnType();
    }

    @Override
    public void visitGetMember(MethodVisitor mv, Member member) {
        boolean isPublic = Modifier.isPublic(member.getModifiers());
        mv.visitMethodInsn(182, "java/lang/Class", isPublic ? "getMethod" : "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
    }

    @Override
    public Class<?>[] getParameterTypes(Member member) {
        return ((Method)member).getParameterTypes();
    }

    @Override
    public String getMemberDescriptor() {
        return "Ljava/lang/reflect/Method;";
    }

    @Override
    public void visitFindMethod(MethodVisitor mv, Member member) {
        mv.visitMethodInsn(182, LOOKUP_INTERNAL_NAME, "unreflect", "(Ljava/lang/reflect/Method;)Ljava/lang/invoke/MethodHandle;", false);
    }

    @Override
    public void visitMemberName(MethodVisitor mv, Member member) {
        mv.visitLdcInsn(member.getName());
    }

    @Override
    public void visitTargetObject(Member member, MethodVisitor mv) {
        if (!Modifier.isStatic(member.getModifiers())) {
            mv.visitVarInsn(25, 1);
            AsmUtils.cast(mv, member.getDeclaringClass());
        }
    }

    @Override
    public int getArgsIndex() {
        return 2;
    }

    @Override
    public String getInvokeExactMethodDescriptor(Member member, Class<?>[] parameterTypes, Class<?> returnType) {
        Stream<Class<?>> parameterTypeStream = Arrays.stream(parameterTypes);
        if (!Modifier.isStatic(member.getModifiers())) {
            parameterTypeStream = Stream.concat(Stream.of(member.getDeclaringClass()), parameterTypeStream);
        }
        return AsmUtils.getMethodDescriptor(returnType, (Class[])parameterTypeStream.toArray(Class[]::new));
    }

    @Override
    public String getInvokeMethodDescriptor() {
        return "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    }
}

