/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.ExternalLoader;
import party.iroiro.luajava.JFunction;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.LuaInstances;
import party.iroiro.luajava.LuaNatives;
import party.iroiro.luajava.LuaProxy;
import party.iroiro.luajava.cleaner.LuaReferable;
import party.iroiro.luajava.cleaner.LuaReference;
import party.iroiro.luajava.util.ClassUtils;
import party.iroiro.luajava.util.Type;
import party.iroiro.luajava.value.AbstractRefLuaValue;
import party.iroiro.luajava.value.ImmutableLuaValue;
import party.iroiro.luajava.value.LuaFunction;
import party.iroiro.luajava.value.LuaTableValue;
import party.iroiro.luajava.value.LuaValue;
import party.iroiro.luajava.value.RefLuaValue;

public abstract class AbstractLua
implements Lua {
    private static final Object[] EMPTY = new Object[0];
    protected static final LuaInstances<AbstractLua> instances = new LuaInstances();
    protected volatile ExternalLoader loader;
    protected final ReferenceQueue<LuaReferable> recyclableReferences;
    protected final ConcurrentHashMap<Integer, LuaReference<?>> recordedReferences;
    protected final LuaNatives C;
    protected final long L;
    protected final int id;
    protected final AbstractLua mainThread;
    protected final List<Lua> subThreads;

    static AbstractLua getInstance(int lid) {
        return instances.get(lid);
    }

    protected AbstractLua(LuaNatives luaNative) {
        this.C = luaNative;
        this.id = instances.add(this);
        this.L = luaNative.luaL_newstate(this.id);
        this.mainThread = this;
        this.subThreads = new LinkedList<Lua>();
        this.loader = null;
        this.recyclableReferences = new ReferenceQueue();
        this.recordedReferences = new ConcurrentHashMap();
    }

    protected AbstractLua(LuaNatives luaNative, long L, int id, @NotNull AbstractLua mainThread) {
        this.loader = null;
        this.C = luaNative;
        this.L = L;
        this.mainThread = mainThread;
        this.id = id;
        this.subThreads = null;
        this.recyclableReferences = null;
        this.recordedReferences = null;
    }

    static int adopt(int mainId, long ptr) {
        AbstractLua lua = AbstractLua.getInstance(mainId);
        LuaInstances.Token<AbstractLua> token = instances.add();
        AbstractLua child = lua.newThread(ptr, token.id, lua);
        lua.addSubThread(child);
        token.setter.accept(child);
        return token.id;
    }

    @Override
    public void checkStack(int extra) throws RuntimeException {
        this.recycleReferences();
        if (this.C.lua_checkstack(this.L, extra) == 0) {
            throw new RuntimeException("No more stack space available");
        }
    }

    @Override
    public void push(@Nullable Object object, Lua.Conversion degree) {
        this.checkStack(1);
        if (object == null) {
            this.pushNil();
        } else if (object instanceof LuaValue) {
            LuaValue value = (LuaValue)object;
            value.push(this);
        } else if (object instanceof LuaFunction) {
            LuaFunction function = (LuaFunction)object;
            this.push(function);
        } else if (degree == Lua.Conversion.NONE) {
            this.pushJavaObjectOrArray(object);
        } else if (object instanceof Boolean) {
            this.push((Boolean)object);
        } else if (object instanceof String) {
            this.push((String)object);
        } else if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
            this.push(((Number)object).intValue());
        } else if (object instanceof Character) {
            this.push(((Character)object).charValue());
        } else if (object instanceof Long) {
            this.push((Long)object);
        } else if (object instanceof Float || object instanceof Double) {
            this.push((Number)object);
        } else if (object instanceof JFunction) {
            this.push((JFunction)object);
        } else if (degree == Lua.Conversion.SEMI) {
            this.pushJavaObjectOrArray(object);
        } else if (object instanceof Class) {
            this.pushJavaClass((Class)object);
        } else if (object instanceof Map) {
            this.push((Map)object);
        } else if (object instanceof Collection) {
            this.push((Collection)object);
        } else if (object.getClass().isArray()) {
            this.pushArray(object);
        } else {
            this.pushJavaObject(object);
        }
    }

    protected void pushJavaObjectOrArray(Object object) {
        this.checkStack(1);
        if (object.getClass().isArray()) {
            this.pushJavaArray(object);
        } else {
            this.pushJavaObject(object);
        }
    }

    @Override
    public void pushNil() {
        this.checkStack(1);
        this.C.lua_pushnil(this.L);
    }

    @Override
    public void push(boolean bool) {
        this.checkStack(1);
        this.C.lua_pushboolean(this.L, bool ? 1 : 0);
    }

    @Override
    public void push(@NotNull Number number) {
        this.checkStack(1);
        this.C.lua_pushnumber(this.L, number.doubleValue());
    }

    @Override
    public void push(long integer) {
        this.checkStack(1);
        this.C.lua_pushinteger(this.L, integer);
    }

    @Override
    public void push(@NotNull String string) {
        this.checkStack(1);
        if (this.needsUTF8Fix(string)) {
            try {
                byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
                this.getGlobal("string");
                this.getField(-1, "char");
                this.remove(-2);
                for (byte b : utf8Bytes) {
                    this.push(b & 0xFF);
                }
                this.pCall(utf8Bytes.length, 1);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.C.luaJ_pushstring(this.L, string);
    }

    @Override
    public void push(@NotNull Map<?, ?> map) {
        this.checkStack(3);
        this.C.lua_createtable(this.L, 0, map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.push(entry.getKey(), Lua.Conversion.FULL);
            this.push(entry.getValue(), Lua.Conversion.FULL);
            this.C.lua_rawset(this.L, -3);
        }
    }

    @Override
    public void push(@NotNull Collection<?> collection) {
        this.checkStack(2);
        this.C.lua_createtable(this.L, collection.size(), 0);
        int i = 1;
        for (Object o : collection) {
            this.push(o, Lua.Conversion.FULL);
            this.C.lua_rawseti(this.L, -2, i);
            ++i;
        }
    }

    @Override
    public void pushArray(@NotNull Object array) throws IllegalArgumentException {
        this.checkStack(2);
        if (array.getClass().isArray()) {
            int len = Array.getLength(array);
            this.C.lua_createtable(this.L, len, 0);
            for (int i = 0; i != len; ++i) {
                this.push(Array.get(array, i), Lua.Conversion.FULL);
                this.C.lua_rawseti(this.L, -2, i + 1);
            }
        } else {
            throw new IllegalArgumentException("Not an array");
        }
    }

    @Override
    public void push(@NotNull JFunction function) {
        this.checkStack(1);
        this.C.luaJ_pushfunction(this.L, function);
    }

    @Override
    public void push(@NotNull LuaValue value) {
        this.checkStack(1);
        value.push(this);
    }

    @Override
    public void push(@NotNull LuaFunction function) {
        this.checkStack(1);
        this.push(new LuaFunctionWrapper(function));
    }

    @Override
    public void pushJavaObject(@NotNull Object object) throws IllegalArgumentException {
        if (object.getClass().isArray()) {
            throw new IllegalArgumentException("Expecting non-array argument");
        }
        this.checkStack(1);
        this.C.luaJ_pushobject(this.L, object);
    }

    @Override
    public void pushJavaArray(@NotNull Object array) throws IllegalArgumentException {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Expecting non-array argument");
        }
        this.checkStack(1);
        this.C.luaJ_pusharray(this.L, array);
    }

    @Override
    public void pushJavaClass(@NotNull Class<?> clazz) {
        this.checkStack(1);
        this.C.luaJ_pushclass(this.L, clazz);
    }

    public int toAbsoluteIndex(int index) {
        if (index > 0) {
            return index;
        }
        if (index <= this.C.getRegistryIndex()) {
            return index;
        }
        if (index == 0) {
            throw new IllegalArgumentException("Stack index should not be 0");
        }
        return this.getTop() + 1 + index;
    }

    @Override
    public double toNumber(int index) {
        return this.C.lua_tonumber(this.L, index);
    }

    @Override
    public long toInteger(int index) {
        return this.C.lua_tointeger(this.L, index);
    }

    @Override
    public boolean toBoolean(int index) {
        return this.C.lua_toboolean(this.L, index) != 0;
    }

    @Override
    @Nullable
    public Object toObject(int index) {
        Lua.LuaType type = this.type(index);
        if (type == null) {
            return null;
        }
        switch (type) {
            case NIL: 
            case NONE: {
                return null;
            }
            case BOOLEAN: {
                return this.toBoolean(index);
            }
            case NUMBER: {
                return this.toNumber(index);
            }
            case STRING: {
                return this.toString(index);
            }
            case TABLE: {
                return this.toMap(index);
            }
            case USERDATA: {
                return this.toJavaObject(index);
            }
        }
        this.pushValue(index);
        return this.get();
    }

    @Override
    @Nullable
    public Object toObject(int index, Class<?> type) {
        Object converted = this.toObject(index);
        if (converted == null) {
            return null;
        }
        if (type.isAssignableFrom(converted.getClass())) {
            return converted;
        }
        if (Number.class.isAssignableFrom(converted.getClass())) {
            Number number = (Number)converted;
            if (type == Byte.TYPE || type == Byte.class) {
                return number.byteValue();
            }
            if (type == Short.TYPE || type == Short.class) {
                return number.shortValue();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return number.intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return number.longValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return number.doubleValue();
            }
        }
        return null;
    }

    private boolean needsUTF8Fix(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String toString(int index) {
        ByteBuffer buffer;
        String result = this.C.lua_tostring(this.L, index);
        if (result != null && this.needsUTF8Fix(result) && (buffer = this.toBuffer(index)) != null) {
            try {
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    @Nullable
    public ByteBuffer toBuffer(int index) {
        return (ByteBuffer)this.C.luaJ_tobuffer(this.L, index);
    }

    @Override
    @Nullable
    public ByteBuffer toDirectBuffer(int index) {
        ByteBuffer buffer = (ByteBuffer)this.C.luaJ_todirectbuffer(this.L, index);
        if (buffer == null) {
            return null;
        }
        return buffer.asReadOnlyBuffer();
    }

    @Override
    @Nullable
    public Object toJavaObject(int index) {
        return this.C.luaJ_toobject(this.L, index);
    }

    @Override
    @Nullable
    public Map<?, ?> toMap(int index) {
        Object obj = this.toJavaObject(index);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        this.checkStack(2);
        index = this.toAbsoluteIndex(index);
        if (this.C.lua_istable(this.L, index) == 1) {
            this.C.lua_pushnil(this.L);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            while (this.C.lua_next(this.L, index) != 0) {
                Object k = this.toObject(-2);
                Object v = this.toObject(-1);
                map.put(k, v);
                this.pop(1);
            }
            return map;
        }
        return null;
    }

    @Override
    @Nullable
    public List<?> toList(int index) {
        Object obj = this.toJavaObject(index);
        if (obj instanceof List) {
            return (List)obj;
        }
        this.checkStack(1);
        if (this.C.lua_istable(this.L, index) == 1) {
            int length = this.rawLength(index);
            ArrayList<Object> list = new ArrayList<Object>();
            list.ensureCapacity(length);
            for (int i = 1; i <= length; ++i) {
                this.C.luaJ_rawgeti(this.L, index, i);
                list.add(this.toObject(-1));
                this.pop(1);
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean isBoolean(int index) {
        return this.C.lua_isboolean(this.L, index) != 0;
    }

    @Override
    public boolean isFunction(int index) {
        return this.C.lua_isfunction(this.L, index) != 0;
    }

    @Override
    public boolean isJavaObject(int index) {
        return this.C.luaJ_isobject(this.L, index) != 0;
    }

    @Override
    public boolean isNil(int index) {
        return this.C.lua_isnil(this.L, index) != 0;
    }

    @Override
    public boolean isNone(int index) {
        return this.C.lua_isnone(this.L, index) != 0;
    }

    @Override
    public boolean isNoneOrNil(int index) {
        return this.C.lua_isnoneornil(this.L, index) != 0;
    }

    @Override
    public boolean isNumber(int index) {
        return this.C.lua_isnumber(this.L, index) != 0;
    }

    @Override
    public boolean isInteger(int index) {
        return this.C.luaJ_isinteger(this.L, index) != 0;
    }

    @Override
    public boolean isString(int index) {
        return this.C.lua_isstring(this.L, index) != 0;
    }

    @Override
    public boolean isTable(int index) {
        return this.C.lua_istable(this.L, index) != 0;
    }

    @Override
    public boolean isThread(int index) {
        return this.C.lua_isthread(this.L, index) != 0;
    }

    @Override
    public boolean isUserdata(int index) {
        return this.C.lua_isuserdata(this.L, index) != 0;
    }

    @Override
    @Nullable
    public Lua.LuaType type(int index) {
        return this.convertType(this.C.lua_type(this.L, index));
    }

    @Override
    public boolean equal(int i1, int i2) {
        return this.C.luaJ_compare(this.L, i1, i2, 0) != 0;
    }

    @Override
    public int rawLength(int index) {
        this.checkStack(1);
        return this.C.luaJ_len(this.L, index);
    }

    @Override
    public boolean lessThan(int i1, int i2) {
        return this.C.luaJ_compare(this.L, i1, i2, -1) != 0;
    }

    @Override
    public boolean rawEqual(int i1, int i2) {
        return this.C.lua_rawequal(this.L, i1, i2) != 0;
    }

    @Override
    public int getTop() {
        return this.C.lua_gettop(this.L);
    }

    @Override
    public void setTop(int index) {
        this.C.lua_settop(this.L, index);
    }

    @Override
    public void insert(int index) {
        this.C.lua_insert(this.L, index);
    }

    @Override
    public void pop(int n) {
        if (n < 0 || this.getTop() < n) {
            throw new LuaException(LuaException.LuaError.MEMORY, "invalid number of items to pop");
        }
        this.C.lua_pop(this.L, n);
    }

    @Override
    public void pushValue(int index) {
        this.checkStack(1);
        this.C.lua_pushvalue(this.L, index);
    }

    @Override
    public void pushThread() {
        this.checkStack(1);
        this.C.lua_pushthread(this.L);
    }

    @Override
    public void remove(int index) {
        this.C.lua_remove(this.L, index);
    }

    @Override
    public void replace(int index) {
        this.C.lua_replace(this.L, index);
    }

    @Override
    public void xMove(Lua other, int n) throws IllegalArgumentException {
        if (!(other instanceof AbstractLua) || ((AbstractLua)other).mainThread != this.mainThread) {
            throw new IllegalArgumentException("Not sharing same global state");
        }
        other.checkStack(n);
        this.C.lua_xmove(this.L, other.getPointer(), n);
    }

    @Override
    public void load(String script) throws LuaException {
        this.checkStack(1);
        this.checkError(this.C.luaL_loadstring(this.L, script), false);
    }

    @Override
    public void load(Buffer buffer, String name) throws LuaException {
        if (!buffer.isDirect()) {
            throw new LuaException(LuaException.LuaError.MEMORY, "Expecting a direct buffer");
        }
        this.checkStack(1);
        this.checkError(this.C.luaJ_loadbuffer(this.L, buffer, buffer.limit(), name), false);
    }

    @Override
    public void run(String script) throws LuaException {
        this.checkStack(1);
        this.checkError(this.C.luaL_dostring(this.L, script), true);
    }

    @Override
    public void run(Buffer buffer, String name) throws LuaException {
        if (!buffer.isDirect()) {
            throw new LuaException(LuaException.LuaError.MEMORY, "Expecting a direct buffer");
        }
        this.checkStack(1);
        this.checkError(this.C.luaJ_dobuffer(this.L, buffer, buffer.limit(), name), true);
    }

    @Override
    public ByteBuffer dump() {
        return (ByteBuffer)this.C.luaJ_dumptobuffer(this.L);
    }

    @Override
    public void pCall(int nArgs, int nResults) throws LuaException {
        this.checkStack(Math.max(nResults - nArgs - 1, 0));
        this.checkError(this.C.lua_pcall(this.L, nArgs, nResults, 0), false);
    }

    @Override
    public AbstractLua newThread() {
        this.checkStack(1);
        LuaInstances.Token<AbstractLua> token = instances.add();
        long K = this.C.luaJ_newthread(this.L, token.id);
        AbstractLua lua = this.newThread(K, token.id, this.mainThread);
        this.mainThread.addSubThread(lua);
        token.setter.accept(lua);
        return lua;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubThread(Lua lua) {
        List<Lua> list = this.subThreads;
        synchronized (list) {
            this.subThreads.add(lua);
        }
    }

    protected abstract AbstractLua newThread(long var1, int var3, AbstractLua var4);

    @Override
    public boolean resume(int nArgs) throws LuaException {
        int code = this.C.luaJ_resume(this.L, nArgs);
        if (this.convertError(code) == LuaException.LuaError.YIELD) {
            return true;
        }
        this.checkError(code, false);
        return false;
    }

    @Override
    public LuaException.LuaError status() {
        return this.convertError(this.C.lua_status(this.L));
    }

    @Override
    public void yield(int n) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void newTable() {
        this.createTable(0, 0);
    }

    @Override
    public void createTable(int nArr, int nRec) {
        this.checkStack(1);
        this.C.lua_createtable(this.L, nArr, nRec);
    }

    @Override
    public void getField(int index, String key) {
        this.checkStack(1);
        this.C.luaJ_getfield(this.L, index, key);
    }

    @Override
    public void setField(int index, String key) {
        this.C.lua_setfield(this.L, index, key);
    }

    @Override
    public void getTable(int index) {
        this.C.luaJ_gettable(this.L, index);
    }

    @Override
    public void setTable(int index) {
        this.C.lua_settable(this.L, index);
    }

    @Override
    public int next(int n) {
        this.checkStack(1);
        return this.C.lua_next(this.L, n);
    }

    @Override
    public void rawGet(int index) {
        this.C.luaJ_rawget(this.L, index);
    }

    @Override
    public void rawGetI(int index, int n) {
        this.checkStack(1);
        this.C.luaJ_rawgeti(this.L, index, n);
    }

    @Override
    public void rawSet(int index) {
        this.C.lua_rawset(this.L, index);
    }

    @Override
    public void rawSetI(int index, int n) {
        this.C.lua_rawseti(this.L, index, n);
    }

    @Override
    public int ref(int index) {
        return this.C.luaL_ref(this.L, index);
    }

    @Override
    public void unRef(int index, int ref) {
        this.C.luaL_unref(this.L, index, ref);
    }

    @Override
    public void getGlobal(String name) {
        this.checkStack(1);
        this.C.luaJ_getglobal(this.L, name);
    }

    @Override
    public void setGlobal(String name) {
        this.C.lua_setglobal(this.L, name);
    }

    @Override
    public int getMetatable(int index) {
        this.checkStack(1);
        return this.C.lua_getmetatable(this.L, index);
    }

    @Override
    public void setMetatable(int index) {
        this.C.luaJ_setmetatable(this.L, index);
    }

    @Override
    public int getMetaField(int index, String field) {
        this.checkStack(1);
        return this.C.luaL_getmetafield(this.L, index, field);
    }

    @Override
    public void getRegisteredMetatable(String typeName) {
        this.checkStack(1);
        this.C.luaJ_getmetatable(this.L, typeName);
    }

    @Override
    public int newRegisteredMetatable(String typeName) {
        this.checkStack(1);
        return this.C.luaL_newmetatable(this.L, typeName);
    }

    @Override
    public void openLibraries() {
        this.checkStack(1);
        this.C.luaL_openlibs(this.L);
        this.C.luaJ_initloader(this.L);
    }

    @Override
    public void openLibrary(String name) {
        this.checkStack(1);
        this.C.luaJ_openlib(this.L, name);
        if ("package".equals(name)) {
            this.C.luaJ_initloader(this.L);
        }
    }

    @Override
    public void concat(int n) {
        if (n == 0) {
            this.checkStack(1);
        }
        this.C.lua_concat(this.L, n);
    }

    @Override
    public void gc() {
        this.recycleReferences();
        this.C.luaJ_gc(this.L);
    }

    @Override
    public void error(String message) {
        throw new RuntimeException(message);
    }

    @Override
    public Object createProxy(Class<?>[] interfaces, Lua.Conversion degree) throws IllegalArgumentException {
        if (interfaces.length >= 1) {
            switch (Objects.requireNonNull(this.type(-1))) {
                case FUNCTION: {
                    String name = ClassUtils.getLuaFunctionalDescriptor(interfaces);
                    if (name == null) {
                        this.pop(1);
                        throw new IllegalArgumentException("Unable to merge interfaces into a functional one");
                    }
                    this.createTable(0, 1);
                    this.insert(this.getTop() - 1);
                    this.setField(-2, name);
                }
                case TABLE: {
                    try {
                        LuaProxy proxy = new LuaProxy(this.ref(), this, degree, interfaces);
                        this.mainThread.recordedReferences.put(proxy.getReference(), new LuaReference<LuaReferable>(proxy, this.mainThread.recyclableReferences));
                        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)proxy);
                    }
                    catch (Throwable e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        this.pop(1);
        throw new IllegalArgumentException("Expecting a table / function and interfaces");
    }

    @Override
    public void register(String name, LuaFunction function) {
        this.push(function);
        this.setGlobal(name);
    }

    @Override
    public void setExternalLoader(ExternalLoader loader) {
        this.mainThread.loader = loader;
    }

    @Override
    public void loadExternal(String module) throws LuaException {
        ExternalLoader loader = this.mainThread.loader;
        if (loader == null) {
            throw new LuaException(LuaException.LuaError.RUNTIME, "External loader not set");
        }
        Buffer buffer = loader.load(module, this);
        if (buffer == null) {
            throw new LuaException(LuaException.LuaError.FILE, "Loader returned null");
        }
        this.load(buffer, module);
    }

    @Override
    public LuaNatives getLuaNatives() {
        return this.C;
    }

    @Override
    public AbstractLua getMainState() {
        return this.mainThread;
    }

    @Override
    public long getPointer() {
        return this.L;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Throwable getJavaError() {
        this.getGlobal("__jthrowable__");
        Object o = this.toJavaObject(-1);
        this.pop(1);
        if (o instanceof Throwable) {
            return (Throwable)o;
        }
        return null;
    }

    @Override
    public int error(@Nullable Throwable e) {
        if (e == null) {
            this.pushNil();
            this.setGlobal("__jthrowable__");
            return 0;
        }
        this.pushJavaObject(e);
        this.setGlobal("__jthrowable__");
        this.push(e.toString());
        return -1;
    }

    @Nullable
    protected Object invokeSpecial(Object object, Method method, @Nullable Object[] params) throws Throwable {
        if (!ClassUtils.isDefault(method)) {
            throw new IncompatibleClassChangeError("Unable to invoke non-default method");
        }
        if (params == null) {
            params = EMPTY;
        }
        for (int i = params.length - 1; i >= 0; --i) {
            Class<?>[] param = params[i];
            if (param == null) {
                this.pushNil();
                continue;
            }
            this.pushJavaObject(param);
        }
        StringBuilder customSignature = new StringBuilder(params.length + 1);
        for (Class<?> type : method.getParameterTypes()) {
            this.appendCustomDescriptor(type, customSignature);
        }
        this.appendCustomDescriptor(method.getReturnType(), customSignature);
        if (this.C.luaJ_invokespecial(this.L, method.getDeclaringClass(), method.getName(), Type.getMethodDescriptor(method), object, customSignature.toString()) == -1) {
            Throwable javaError = this.getJavaError();
            this.pop(1);
            throw Objects.requireNonNull(javaError);
        }
        if (method.getReturnType() == Void.TYPE) {
            return null;
        }
        Object ret = this.toJavaObject(-1);
        this.pop(1);
        return ret;
    }

    private void appendCustomDescriptor(Class<?> type, StringBuilder customSignature) {
        if (type.isPrimitive()) {
            customSignature.append(Type.getPrimitiveDescriptor(type));
        } else {
            customSignature.append("_");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.mainThread == this) {
            List<Lua> list = this.subThreads;
            synchronized (list) {
                for (Lua lua : this.subThreads) {
                    instances.remove(lua.getId());
                }
                this.subThreads.clear();
                instances.remove(this.id);
                this.C.lua_close(this.L);
            }
        }
        List<Lua> list = this.mainThread.subThreads;
        synchronized (list) {
            if (this.mainThread.subThreads.remove(this)) {
                this.C.luaJ_removestateindex(this.L);
                instances.remove(this.getId());
            }
        }
    }

    @Override
    public int ref() {
        return this.ref(this.C.getRegistryIndex());
    }

    @Override
    public void refGet(int ref) {
        this.rawGetI(this.C.getRegistryIndex(), ref);
    }

    @Override
    public void unref(int ref) {
        this.unRef(this.C.getRegistryIndex(), ref);
    }

    protected void checkError(int code, boolean runtime) throws LuaException {
        String message;
        LuaException.LuaError error;
        LuaException.LuaError luaError = runtime ? (code == 0 ? LuaException.LuaError.OK : LuaException.LuaError.RUNTIME) : (error = this.convertError(code));
        if (error == LuaException.LuaError.OK) {
            return;
        }
        if (this.type(-1) == Lua.LuaType.STRING) {
            message = this.toString(-1);
            this.pop(1);
        } else {
            message = "Lua-side error";
        }
        LuaException e = new LuaException(error, message);
        Throwable javaError = this.getJavaError();
        if (javaError != null) {
            e.initCause(javaError);
            this.error((Throwable)null);
        }
        throw e;
    }

    public abstract LuaException.LuaError convertError(int var1);

    public abstract Lua.LuaType convertType(int var1);

    @Override
    public LuaValue get(String globalName) {
        this.getGlobal(globalName);
        return this.get();
    }

    @Override
    public void set(String key, Object value) {
        this.push(value, Lua.Conversion.SEMI);
        this.setGlobal(key);
    }

    @Override
    public LuaValue[] eval(String command) throws LuaException {
        this.load(command);
        return this.get().call(new Object[0]);
    }

    @Override
    public LuaValue get() {
        Lua.LuaType type = this.type(-1);
        switch (Objects.requireNonNull(type)) {
            case NIL: 
            case NONE: {
                this.pop(1);
                return this.fromNull();
            }
            case BOOLEAN: {
                boolean b = this.toBoolean(-1);
                this.pop(1);
                return this.from(b);
            }
            case NUMBER: {
                LuaValue value = this.isInteger(-1) ? this.from(this.toInteger(-1)) : this.from(this.toNumber(-1));
                this.pop(1);
                return value;
            }
            case STRING: {
                String s = this.toString(-1);
                this.pop(1);
                return this.from(s);
            }
        }
        AbstractRefLuaValue ref = type == Lua.LuaType.TABLE ? new LuaTableValue(this, type) : new RefLuaValue(this, type);
        this.mainThread.recordedReferences.put(ref.getReference(), new LuaReference<LuaReferable>(ref, this.mainThread.recyclableReferences));
        return ref;
    }

    @Override
    public LuaValue fromNull() {
        return ImmutableLuaValue.NIL(this);
    }

    @Override
    public LuaValue from(boolean b) {
        return b ? ImmutableLuaValue.TRUE(this) : ImmutableLuaValue.FALSE(this);
    }

    @Override
    public LuaValue from(double n) {
        return ImmutableLuaValue.NUMBER(this, n);
    }

    @Override
    public LuaValue from(long n) {
        return ImmutableLuaValue.LONG(this, n);
    }

    @Override
    public LuaValue from(String s) {
        return ImmutableLuaValue.STRING(this, s);
    }

    private void recycleReferences() {
        LuaReference ref = (LuaReference)this.mainThread.recyclableReferences.poll();
        while (ref != null) {
            this.mainThread.recordedReferences.remove(ref.getReference());
            this.unref(ref.getReference());
            ref = (LuaReference)this.mainThread.recyclableReferences.poll();
        }
    }

    protected boolean shouldSynchronize() {
        return true;
    }

    private static class LuaFunctionWrapper
    implements JFunction {
        @NotNull
        private final LuaFunction function;

        public LuaFunctionWrapper(@NotNull LuaFunction function) {
            this.function = function;
        }

        @Override
        public int __call(Lua L) {
            LuaValue[] args = new LuaValue[L.getTop()];
            for (int i = 0; i < args.length; ++i) {
                args[args.length - i - 1] = L.get();
            }
            LuaValue[] results = this.function.call(L, args);
            if (results != null) {
                for (LuaValue result : results) {
                    L.push(result);
                }
            }
            return results == null ? 0 : results.length;
        }
    }
}

