/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.ExternalLoader;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.util.ClassUtils;

public class ClassPathLoader
implements ExternalLoader {
    protected final ClassLoader classLoader;

    public ClassPathLoader() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public ClassPathLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Buffer load(String module, Lua ignored) {
        try (InputStream resource = Objects.requireNonNull(this.classLoader.getResourceAsStream(this.getPath(module)));){
            int i;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            do {
                if ((i = resource.read(bytes)) == -1) continue;
                output.write(bytes, 0, i);
            } while (i != -1);
            ByteBuffer buffer = ByteBuffer.allocateDirect(output.size());
            output.writeTo(new BufferOutputStream(buffer));
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getPath(String module) {
        return module.replace('.', '/') + ".lua";
    }

    public static class BufferOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;

        public BufferOutputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int i) {
            this.buffer.put((byte)i);
        }

        @Override
        public void write(byte @NotNull [] bytes, int off, int len) {
            this.buffer.put(bytes, off, len);
        }
    }
}

