/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import me.sunlan.fastreflection.FastClass;
import me.sunlan.fastreflection.FastField;
import me.sunlan.fastreflection.FastMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.AbstractLua;
import party.iroiro.luajava.JFunction;
import party.iroiro.luajava.Jua;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.LuaProxy;
import party.iroiro.luajava.util.ClassUtils;
import party.iroiro.luajava.util.LRUCache;
import party.iroiro.luajava.value.LuaValue;

public abstract class JuaAPI {
    private static final short UNRESOLVED_CACHE_SIZE = 10000;
    private static final LinkedHashSet<String> UNRESOLVED = new LinkedHashSet<String>(10000){

        @Override
        public boolean add(String obj) {
            Iterator iterator;
            if (this.contains(obj)) {
                return false;
            }
            if (this.size() >= 10000 && (iterator = this.iterator()).hasNext()) {
                iterator.next();
                iterator.remove();
            }
            return super.add(obj);
        }
    };
    private static final LRUCache<Class<?>, Boolean, Constructor<?>[]> CONSTRUCTORS_CACHE = new LRUCache(25, 1, 4);
    private static final LRUCache<Class<?>, String, Method[]> MEMBER_METHOD_CACHE = new LRUCache(25, 10, 4);
    private static final LRUCache<Class<?>, String, OptionalField> OBJECT_FIELD_CACHE = new LRUCache(25, 10, 4);
    private static final LRUCache<Class<?>, String, Constructor<?>> CONSTRUCTOR_CACHE = new LRUCache(25, 5, 4);
    private static final LRUCache<Class<?>, String, Method> METHOD_CACHE = new LRUCache(25, 50, 4);
    private static final Pattern COMMA_SPLIT = Pattern.compile(",");
    static final ExecutableWrapper<Constructor<?>> CONSTRUCTOR_WRAPPER = new ExecutableWrapper<Constructor<?>>(){

        @Override
        @Nullable
        public String getName(Constructor<?> executable) {
            return null;
        }

        @Override
        public Class<?>[] getParameterTypes(Constructor<?> executable) {
            return executable.getParameterTypes();
        }
    };
    static final ExecutableWrapper<Method> METHOD_WRAPPER = new ExecutableWrapper<Method>(){

        @Override
        public String getName(Method executable) {
            return executable.getName();
        }

        @Override
        public Class<?>[] getParameterTypes(Method executable) {
            return executable.getParameterTypes();
        }
    };

    public static ByteBuffer allocateDirect(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    public static int unwrap(int id, Object obj) {
        AbstractLua L = Jua.get(id);
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(obj);
            if (handler instanceof LuaProxy) {
                LuaProxy proxy = (LuaProxy)handler;
                if (proxy.L.mainThread == L.getMainState()) {
                    L.refGet(proxy.ref);
                    return 1;
                }
                L.push("Proxied table is on different states");
            } else {
                L.push("No a LuaProxy backed object");
            }
            return -1;
        }
        catch (IllegalArgumentException | SecurityException e) {
            return L.error(e);
        }
    }

    public static int load(int id, String module) {
        AbstractLua L = Jua.get(id);
        try {
            L.loadExternal(module);
        }
        catch (LuaException e) {
            L.push("\n  no module '" + module + "': " + e);
        }
        return 1;
    }

    public static int loadModule(int id, String module) {
        int i = module.lastIndexOf(46);
        if (i == -1) {
            AbstractLua L = Jua.get(id);
            L.pushNil();
            L.push("\n  no method '" + module + "': invalid name");
            return 2;
        }
        return JuaAPI.loadLib(id, module.substring(0, i), module.substring(i + 1));
    }

    public static int loadLib(int id, String className, String methodName) {
        AbstractLua L = Jua.get(id);
        try {
            FastMethod method;
            Class<?> clazz = ClassUtils.forName(className);
            FastClass<Lua> fastClass = FastClass.create(clazz);
            try {
                method = fastClass.getMethod(methodName, Lua.class);
            }
            catch (NoSuchMethodException e) {
                L.pushNil();
                L.push("\n  no method '" + methodName + "': no such method");
                return 2;
            }
            if (method.getReturnType().getRawClass() == Integer.TYPE) {
                L.push(new JFunction(){

                    @Override
                    public int __call(Lua l) {
                        try {
                            return (Integer)method.invoke(null, l);
                        }
                        catch (Throwable e) {
                            return l.error(e);
                        }
                    }
                });
                return 1;
            }
            L.pushNil();
            L.push("\n  no method '" + methodName + "': not returning int values");
            return 2;
        }
        catch (ClassNotFoundException ignored) {
            L.pushNil();
            L.push("\n  no method '" + methodName + "': no such method");
            return 2;
        }
    }

    public static int proxy(int id) {
        AbstractLua L = Jua.get(id);
        int interfaces = L.getTop() - 1;
        LinkedList classes = new LinkedList();
        for (int i = 1; i <= interfaces; ++i) {
            Class<?> c = JuaAPI.looseGetClass(L, i);
            if (c == null || !c.isInterface()) {
                L.push("bad argument #" + i + " to 'java.proxy' (expecting an interface)");
                return -1;
            }
            classes.add(c);
        }
        Object o = L.createProxy(classes.toArray(new Class[0]), Lua.Conversion.SEMI);
        L.pushJavaObject(o);
        return 1;
    }

    @Nullable
    private static Class<?> looseGetClass(Lua L, int i) {
        if (L.isUserdata(i)) {
            Object o = L.toJavaObject(i);
            return o instanceof Class ? (Class)o : null;
        }
        String name = L.toString(i);
        if (name != null) {
            try {
                return ClassUtils.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static int javaImport(int id, String className) {
        AbstractLua L = Jua.get(id);
        try {
            L.pushJavaClass(ClassUtils.forName(className));
            return 1;
        }
        catch (ClassNotFoundException e) {
            return L.error(e);
        }
    }

    public static int luaify(int id) {
        AbstractLua L = Jua.get(id);
        Object o = L.toJavaObject(-1);
        if (o != null) {
            L.push(o, Lua.Conversion.FULL);
        }
        return 1;
    }

    public static int threadNewId(int mainId, long ptr) {
        return AbstractLua.adopt(mainId, ptr);
    }

    public static int freeThreadId(int id) {
        AbstractLua L = Jua.get(id);
        if (L.getMainState() != L) {
            L.close();
            return 0;
        }
        throw new LuaException(LuaException.LuaError.MEMORY, "unable to detach a main state");
    }

    public static int objectIndex(int index, @NotNull Object object, String name) {
        return JuaAPI.fieldIndex(Jua.get(index), object.getClass(), object, name);
    }

    public static int objectInvoke(int index, @NotNull Object obj, @Nullable String name, int paramCount) {
        if (name == null) {
            return JuaAPI.juaFunctionCall(index, obj, paramCount);
        }
        return JuaAPI.methodInvoke(index, obj.getClass(), obj, name, paramCount);
    }

    private static int juaFunctionCall(int index, Object obj, int ignored) {
        AbstractLua L = Jua.get(index);
        if (obj instanceof JFunction) {
            return ((JFunction)obj).__call(L);
        }
        L.push("error invoking object (expecting a JFunction)");
        return -1;
    }

    public static int objectInvoke(int index, Object obj, String name, String notSignature, int paramCount) {
        int colon = name.indexOf(58);
        if (colon == -1) {
            return JuaAPI.methodInvoke(index, obj.getClass(), obj, name, notSignature, paramCount);
        }
        String iClass = name.substring(0, colon);
        String method = name.substring(colon + 1);
        try {
            return JuaAPI.methodInvoke(index, ClassUtils.forName(iClass), obj, method, notSignature, paramCount);
        }
        catch (ClassNotFoundException e) {
            return Jua.get(index).error(e);
        }
    }

    public static int objectNewIndex(int index, Object obj, String name) {
        return JuaAPI.fieldNewIndex(index, obj.getClass(), obj, name);
    }

    public static int classNew(int index, Object oClazz, int paramCount) {
        Constructor<?> constructor;
        AbstractLua L = Jua.get(index);
        if (!(oClazz instanceof Class)) {
            L.push("bad argument #1 to java.new (expecting Class<?>)");
            return -1;
        }
        Class clazz = (Class)oClazz;
        if (clazz.isInterface()) {
            try {
                L.pushJavaObject(L.createProxy(new Class[]{clazz}, Lua.Conversion.SEMI));
                return 1;
            }
            catch (IllegalArgumentException e) {
                return L.error(e);
            }
        }
        Object[] objects = new Object[paramCount];
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(clazz, Boolean.TRUE);
        if (constructors == null) {
            constructors = clazz.getConstructors();
            CONSTRUCTORS_CACHE.put(clazz, Boolean.TRUE, constructors);
        }
        if ((constructor = JuaAPI.matchMethod(L, constructors, CONSTRUCTOR_WRAPPER, objects)) != null) {
            return JuaAPI.construct(L, objects, constructor);
        }
        L.push("no matching constructor found");
        return -1;
    }

    private static int construct(Lua L, Object[] objects, Constructor<?> constructor) {
        try {
            Object obj = constructor.newInstance(objects);
            L.pushJavaObject(obj);
            return 1;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return L.error(e);
        }
        catch (InvocationTargetException e) {
            return L.error(e.getCause());
        }
    }

    public static int classIndex(int index, Class<?> clazz, String name) {
        AbstractLua L = Jua.get(index);
        if (name.equals("class")) {
            L.pushJavaObject(clazz);
            return 1;
        }
        int i = JuaAPI.fieldIndex(L, clazz, null, name);
        if (i == 1) {
            return 1;
        }
        String className = clazz.getName() + "$" + name;
        if (UNRESOLVED.contains(className)) {
            return i;
        }
        try {
            L.pushJavaClass(ClassUtils.forName(className));
            return 1;
        }
        catch (ClassNotFoundException e) {
            UNRESOLVED.add(className);
            return i;
        }
    }

    public static int classInvoke(int index, Class<?> clazz, String name, int paramCount) {
        return JuaAPI.methodInvoke(index, clazz, null, name, paramCount);
    }

    public static int classInvoke(int index, Class<?> clazz, String name, String notSignature, int paramCount) {
        return JuaAPI.methodInvoke(index, clazz, null, name, notSignature, paramCount);
    }

    public static int classNewIndex(int index, Class<?> clazz, String name) {
        return JuaAPI.fieldNewIndex(index, clazz, null, name);
    }

    public static int arrayNew(int index, Object oClass, int size) {
        AbstractLua L = Jua.get(index);
        if (!(oClass instanceof Class) || oClass == Void.TYPE) {
            L.push("bad argument #1 to 'java.array' (expecting Class<?>)");
            return -1;
        }
        Class clazz = (Class)oClass;
        if (size >= 0) {
            L.pushJavaArray(Array.newInstance(clazz, size));
        } else {
            int depth = -size;
            int[] sizes = new int[depth];
            for (int i = size; i <= -1; ++i) {
                if (!L.isNumber(i)) {
                    L.push("bad argument #" + (i - size + 2) + " to 'java.array' (expecting number)");
                    return -1;
                }
                int current = (int)L.toNumber(i);
                if (current < 0) {
                    L.push("bad argument #" + (i - size + 2) + " to 'java.array' (expecting non negative)");
                    return -1;
                }
                sizes[i - size] = current;
            }
            L.pushJavaArray(Array.newInstance(clazz, sizes));
        }
        return 1;
    }

    public static int arrayIndex(int index, Object obj, int i) {
        AbstractLua L = Jua.get(index);
        try {
            Object e = Array.get(obj, i - 1);
            L.push(e, Lua.Conversion.SEMI);
            return 1;
        }
        catch (Exception e) {
            return L.error(e);
        }
    }

    public static int arrayNewIndex(int index, Object obj, int i) {
        AbstractLua L = Jua.get(index);
        try {
            Array.set(obj, i - 1, L.toObject(L.getTop(), obj.getClass().getComponentType()));
            return 0;
        }
        catch (Exception e) {
            return L.error(e);
        }
    }

    public static int arrayLength(Object obj) {
        try {
            return Array.getLength(obj);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int methodInvoke(int index, Class<?> clazz, @Nullable Object obj, String name, int paramCount) {
        Method method;
        AbstractLua L = Jua.get(index);
        Object[] objects = new Object[paramCount];
        Method[] methods = MEMBER_METHOD_CACHE.get(clazz, name);
        if (methods == null) {
            ArrayList<Method> namedMethods = new ArrayList<Method>();
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(name)) continue;
                namedMethods.add(method2);
            }
            methods = namedMethods.toArray(new Method[0]);
            MEMBER_METHOD_CACHE.put(clazz, name, methods);
        }
        if ((method = JuaAPI.matchMethod(L, methods, METHOD_WRAPPER, objects)) == null) {
            L.push("no matching method found: " + clazz.getSimpleName() + "#" + name);
            return -1;
        }
        return JuaAPI.methodInvoke(L, method, obj, objects);
    }

    public static int methodInvoke(int index, Class<?> clazz, @Nullable Object obj, String name, String notSignature, int paramCount) {
        AbstractLua L = Jua.get(index);
        if ("new".equals(name)) {
            if (obj == null) {
                Constructor<?> constructor = JuaAPI.matchMethod(clazz, notSignature);
                if (constructor != null) {
                    Object[] objects = new Object[paramCount];
                    if (JuaAPI.matchMethod(L, new Constructor[]{constructor}, CONSTRUCTOR_WRAPPER, objects) != null) {
                        return JuaAPI.construct(L, objects, constructor);
                    }
                }
                L.push("no matching constructor found");
                return -1;
            }
            L.push("bad argument to constructor (Class<?> expected, got Object)");
            return -1;
        }
        Method method = JuaAPI.matchMethod(clazz, name, notSignature);
        if (method != null) {
            Object[] objects = new Object[paramCount];
            if (JuaAPI.matchMethod(L, new Method[]{method}, METHOD_WRAPPER, objects) != null) {
                if (clazz.isInterface()) {
                    return JuaAPI.specialInvoke(L, method, obj, objects);
                }
                return JuaAPI.methodInvoke(L, method, obj, objects);
            }
        }
        L.push("no method with matching signature found: " + clazz.getSimpleName() + "#" + name + "(" + notSignature + ")");
        return -1;
    }

    private static int specialInvoke(AbstractLua L, Method method, @Nullable Object obj, Object[] objects) {
        Object ret;
        try {
            ret = L.invokeSpecial(obj, method, objects);
        }
        catch (Throwable e) {
            return L.error(e);
        }
        if (ret == null) {
            return 0;
        }
        L.push(ret, Lua.Conversion.SEMI);
        return 1;
    }

    public static int methodInvoke(Lua L, Method method, @Nullable Object obj, Object[] objects) {
        Object ret;
        if (Modifier.isPublic(method.getModifiers()) && !method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            ret = method.invoke(obj, objects);
        }
        catch (IllegalAccessException e) {
            return L.error(e);
        }
        catch (InvocationTargetException e) {
            return L.error(e.getCause());
        }
        if (ret == null) {
            return 0;
        }
        L.push(ret, Lua.Conversion.SEMI);
        return 1;
    }

    public static int fieldIndex(Lua L, Class<?> clazz, @Nullable Object object, String name) {
        try {
            FastField fastField;
            OptionalField optionalField = OBJECT_FIELD_CACHE.get(clazz, name);
            if (optionalField == null) {
                FastClass<?> fastClass = FastClass.create(clazz);
                fastField = fastClass.getField(name);
                OBJECT_FIELD_CACHE.put(clazz, name, new OptionalField(fastField));
            } else {
                fastField = optionalField.fastField;
                if (fastField == null) {
                    return 2;
                }
            }
            if (fastField == null) {
                return 2;
            }
            Object obj = fastField.get(object);
            L.push(obj, Lua.Conversion.SEMI);
            return 1;
        }
        catch (Throwable ignored) {
            OBJECT_FIELD_CACHE.put(clazz, name, new OptionalField(null));
            return 2;
        }
    }

    private static int fieldNewIndex(int index, Class<?> clazz, Object object, String name) {
        AbstractLua L = Jua.get(index);
        try {
            FastField fastField;
            OptionalField optionalField = OBJECT_FIELD_CACHE.get(clazz, name);
            if (optionalField == null) {
                FastClass<?> fastClass = FastClass.create(clazz);
                fastField = fastClass.getField(name);
                OBJECT_FIELD_CACHE.put(clazz, name, new OptionalField(fastField));
            } else {
                fastField = optionalField.fastField;
                if (fastField == null) {
                    return L.error(new NoSuchFieldException(name));
                }
            }
            if (fastField == null) {
                return L.error(new NoSuchFieldException(name));
            }
            Class<?> type = fastField.getDeclaringClass().getRawClass().getDeclaredField(fastField.getName()).getType();
            Object o = JuaAPI.convertFromLua(L, type, 3);
            fastField.set(object, o);
            return 0;
        }
        catch (Throwable e) {
            OBJECT_FIELD_CACHE.put(clazz, name, new OptionalField(null));
            return L.error(e);
        }
    }

    @Nullable
    private static <T> T matchMethod(Lua L, T[] methods, ExecutableWrapper<T> wrapper, Object[] params) {
        for (T method : methods) {
            Class<?>[] classes = wrapper.getParameterTypes(method);
            if (classes.length != params.length) continue;
            try {
                for (int i = 0; i != params.length; ++i) {
                    params[i] = JuaAPI.convertFromLua(L, classes[i], -params.length + i);
                }
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            return method;
        }
        return null;
    }

    @Nullable
    private static Constructor<?> matchMethod(Class<?> clazz, String notSignature) {
        Constructor<?> cached = CONSTRUCTOR_CACHE.get(clazz, notSignature);
        if (cached != null) {
            return cached;
        }
        Class<?>[] classes = JuaAPI.getClasses(notSignature);
        try {
            return clazz.getConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method matchMethod(Class<?> clazz, String name, String notSignature) {
        Method cached = METHOD_CACHE.get(clazz, name + ",," + notSignature);
        if (cached != null) {
            return cached;
        }
        Class<?>[] classes = JuaAPI.getClasses(notSignature);
        try {
            return clazz.getMethod(name, classes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Object convertFromLua(Lua L, Class<?> clazz, int index) throws IllegalArgumentException {
        Lua.LuaType type = L.type(index);
        if (type == Lua.LuaType.NIL) {
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException("Primitive not accepting null values");
            }
            return null;
        }
        if (type == Lua.LuaType.BOOLEAN) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return L.toBoolean(index);
            }
        } else {
            String descriptor;
            if (type == Lua.LuaType.STRING && clazz.isAssignableFrom(String.class)) {
                return L.toString(index);
            }
            if (type == Lua.LuaType.NUMBER) {
                if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
                    Number v = L.isInteger(index) ? (Number)L.toInteger(index) : (Number)L.toNumber(index);
                    return JuaAPI.convertNumber(v, clazz);
                }
                if (Character.class == clazz) {
                    return Character.valueOf((char)L.toNumber(index));
                }
                if (Boolean.class == clazz) {
                    return L.toNumber(index) != 0.0;
                }
                if (clazz == Object.class) {
                    return L.toNumber(index);
                }
            } else if (type == Lua.LuaType.USERDATA) {
                Object object = L.toJavaObject(index);
                if (object != null && clazz.isAssignableFrom(object.getClass())) {
                    return object;
                }
            } else if (type == Lua.LuaType.TABLE) {
                if (clazz.isAssignableFrom(List.class)) {
                    return L.toList(index);
                }
                if (clazz.isArray() && clazz.getComponentType() == Object.class) {
                    return Objects.requireNonNull(L.toList(index)).toArray(new Object[0]);
                }
                if (clazz.isAssignableFrom(Map.class)) {
                    return L.toMap(index);
                }
                if (clazz.isInterface() && !clazz.isAnnotation()) {
                    L.pushValue(index);
                    return L.createProxy(new Class[]{clazz}, Lua.Conversion.SEMI);
                }
            } else if (type == Lua.LuaType.FUNCTION && (descriptor = ClassUtils.getLuaFunctionalDescriptor(clazz)) != null) {
                L.pushValue(index);
                L.createTable(0, 1);
                L.insert(L.getTop() - 1);
                L.setField(-2, descriptor);
                return L.createProxy(new Class[]{clazz}, Lua.Conversion.SEMI);
            }
        }
        if (clazz.isAssignableFrom(LuaValue.class)) {
            L.pushValue(index);
            return L.get();
        }
        throw new IllegalArgumentException("Unable to convert to " + clazz.getName());
    }

    private static Object convertNumber(Number i, Class<?> clazz) throws IllegalArgumentException {
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE == clazz) {
                return i.intValue() != 0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf((char)i.byteValue());
            }
            if (Byte.TYPE == clazz) {
                return i.byteValue();
            }
            if (Short.TYPE == clazz) {
                return i.shortValue();
            }
            if (Integer.TYPE == clazz) {
                return i.intValue();
            }
            if (Long.TYPE == clazz) {
                return i.longValue();
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(i.floatValue());
            }
            return i.doubleValue();
        }
        return JuaAPI.convertBoxedNumber(i, clazz);
    }

    private static Number convertBoxedNumber(Number i, Class<?> clazz) throws IllegalArgumentException {
        if (Byte.class == clazz) {
            return i.byteValue();
        }
        if (Short.class == clazz) {
            return i.shortValue();
        }
        if (Integer.class == clazz) {
            return i.intValue();
        }
        if (Long.class == clazz) {
            return i.longValue();
        }
        if (Float.class == clazz) {
            return Float.valueOf(i.floatValue());
        }
        if (Double.class == clazz) {
            return i.doubleValue();
        }
        throw new IllegalArgumentException("Unsupported conversion");
    }

    public static Class<?>[] getClasses(String notSignature) {
        if (notSignature == null || notSignature.isEmpty()) {
            return new Class[0];
        }
        String[] names = COMMA_SPLIT.split(notSignature);
        Class[] classes = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                classes[i] = ClassUtils.forName(names[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                classes[i] = null;
            }
        }
        return classes;
    }

    static interface ExecutableWrapper<T> {
        @Nullable
        public String getName(T var1);

        public Class<?>[] getParameterTypes(T var1);
    }

    private static final class OptionalField {
        @Nullable
        public final FastField fastField;

        private OptionalField(@Nullable FastField fastField) {
            this.fastField = fastField;
        }
    }
}

