/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuaInstances<T> {
    private final ArrayList<T> instances;
    private final HashSet<Integer> freeIds = new HashSet();

    protected LuaInstances() {
        this.instances = new ArrayList();
    }

    protected synchronized int add(@NotNull T instance) {
        return this.addNullable(instance);
    }

    protected synchronized int addNullable(@Nullable T instance) {
        if (this.freeIds.isEmpty()) {
            int id = this.instances.size();
            this.instances.add(instance);
            return id;
        }
        Iterator<Integer> first = this.freeIds.iterator();
        Integer id = first.next();
        first.remove();
        this.instances.set(id, instance);
        return id;
    }

    protected synchronized Token<T> add() {
        final int id = this.addNullable(null);
        return new Token(id, new Token.Consumer<T>(){

            @Override
            public void accept(T lua) {
                LuaInstances.this.set(id, lua);
            }
        });
    }

    private synchronized void set(int id, @Nullable T instance) {
        this.instances.set(id, instance);
    }

    protected synchronized T get(int id) {
        return this.instances.get(id);
    }

    protected synchronized void remove(int id) {
        if (id == this.instances.size() - 1) {
            this.instances.remove(id);
        } else {
            this.instances.set(id, null);
            this.freeIds.add(id);
        }
    }

    protected synchronized int size() {
        return this.instances.size() - this.freeIds.size();
    }

    public static class Token<T> {
        public final int id;
        public final Consumer<T> setter;

        private Token(int id, Consumer<T> setter) {
            this.id = id;
            this.setter = setter;
        }

        public static interface Consumer<T> {
            public void accept(T var1);
        }
    }
}

