/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import party.iroiro.luajava.AbstractLua;
import party.iroiro.luajava.JuaAPI;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.cleaner.LuaReferable;
import party.iroiro.luajava.util.ClassUtils;

public final class LuaProxy
implements InvocationHandler,
LuaReferable {
    final int ref;
    final AbstractLua L;
    private final Lua.Conversion degree;
    private final Class<?>[] interfaces;

    LuaProxy(int ref, AbstractLua L, Lua.Conversion degree, Class<?>[] interfaces) {
        this.ref = ref;
        this.L = L;
        this.degree = degree;
        this.interfaces = interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        if (this.L.shouldSynchronize()) {
            AbstractLua abstractLua = this.L.getMainState();
            synchronized (abstractLua) {
                return this.syncFreeInvoke(object, method, objects);
            }
        }
        return this.syncFreeInvoke(object, method, objects);
    }

    private Object syncFreeInvoke(Object object, Method method, Object[] objects) throws Throwable {
        int nResults;
        int top = this.L.getTop();
        this.L.refGet(this.ref);
        this.L.getField(-1, method.getName());
        if (this.L.isNil(-1)) {
            this.L.setTop(top);
            return this.callDefaultMethod(object, method, objects);
        }
        this.L.pushJavaObject(object);
        int n = nResults = method.getReturnType() == Void.TYPE ? 0 : 1;
        if (objects == null) {
            this.L.pCall(1, nResults);
        } else {
            for (Object o : objects) {
                this.L.push(o, this.degree);
            }
            this.L.pCall(objects.length + 1, nResults);
        }
        try {
            if (method.getReturnType() == Void.TYPE) {
                this.L.setTop(top);
                return null;
            }
            Object o = JuaAPI.convertFromLua(this.L, method.getReturnType(), -1);
            this.L.setTop(top);
            return o;
        }
        catch (IllegalArgumentException e) {
            this.L.setTop(top);
            throw e;
        }
    }

    private Object callDefaultMethod(Object o, Method method, Object[] objects) throws Throwable {
        if (ClassUtils.isDefault(method)) {
            return this.L.invokeSpecial(o, method, objects);
        }
        return this.callObjectDefault(o, method, objects);
    }

    private Object callObjectDefault(Object o, Method method, Object[] objects) {
        if (LuaProxy.methodEquals(method, Integer.TYPE, "hashCode", new Class[0])) {
            return this.hashCode();
        }
        if (LuaProxy.methodEquals(method, Boolean.TYPE, "equals", Object.class)) {
            return o == objects[0];
        }
        if (LuaProxy.methodEquals(method, String.class, "toString", new Class[0])) {
            return "LuaProxy" + Arrays.toString(this.interfaces) + "@" + Integer.toHexString(this.hashCode());
        }
        throw new LuaException(LuaException.LuaError.JAVA, "method not implemented: " + method);
    }

    public static boolean methodEquals(Method method, Class<?> returnType, String name, Class<?> ... parameters) {
        return method.getReturnType() == returnType && name.equals(method.getName()) && Arrays.equals(method.getParameterTypes(), parameters);
    }

    @Override
    public int getReference() {
        return this.ref;
    }
}

