/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.util;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char NESTED_CLASS_SEPARATOR = '$';
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap;
    private static final Map<String, Class<?>> primitiveTypeNameMap;
    private static final Map<String, Class<?>> commonClassCache;
    public static volatile ClassLoader DEFAULT_CLASS_LOADER;
    private static final Set<String> OBJECT_METHODS;
    private static final Method IS_DEFAULT;

    private static void registerOptionalClasses() {
        try {
            ClassUtils.registerCommonClasses(Class.forName("java.util.Optional"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = DEFAULT_CLASS_LOADER;
        if (cl != null) {
            return cl;
        }
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private static Class<?> forName(String name, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz == null) {
            clazz = commonClassCache.get(name);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(name, false, clToUse);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            int previousDotIndex = name.lastIndexOf(46, lastDotIndex - 1);
            if (lastDotIndex != -1 && previousDotIndex != -1 && Character.isUpperCase(name.charAt(previousDotIndex + 1))) {
                String nestedClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return Class.forName(nestedClassName, false, clToUse);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    @Nullable
    public static Class<?> resolvePrimitiveClassName(@Nullable String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 7) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        try {
            return ClassUtils.forName(name, null);
        }
        catch (ClassNotFoundException ex) {
            try {
                return ClassUtils.forName(name, ClassUtils.class.getClassLoader());
            }
            catch (ClassNotFoundException ex2) {
                try {
                    return ClassUtils.forName(name, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ex;
                }
            }
        }
    }

    @Nullable
    public static String getLuaFunctionalDescriptor(Class<?> ... classes) {
        if (ClassUtils.allInterfaces(classes)) {
            ArrayDeque searchQueue = new ArrayDeque(1);
            String name = null;
            Collections.addAll(searchQueue, classes);
            while (!searchQueue.isEmpty()) {
                Class aClass = (Class)searchQueue.poll();
                for (Method m : aClass.getDeclaredMethods()) {
                    String mName;
                    if (!Modifier.isAbstract(m.getModifiers()) || OBJECT_METHODS.contains(mName = m.getName())) continue;
                    if (name == null) {
                        name = mName;
                        continue;
                    }
                    if (name.equals(mName)) continue;
                    return null;
                }
                Collections.addAll(searchQueue, aClass.getInterfaces());
            }
            return name;
        }
        return null;
    }

    private static boolean allInterfaces(Class<?>[] classes) {
        for (Class<?> c : classes) {
            if (c.isInterface() && !c.isAnnotation()) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefault(Method method) {
        if (IS_DEFAULT == null) {
            return false;
        }
        try {
            return (Boolean)IS_DEFAULT.invoke((Object)method, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        Method isDefaultMethod;
        primitiveWrapperTypeMap = new IdentityHashMap(9);
        primitiveTypeNameMap = new HashMap(32);
        commonClassCache = new HashMap(64);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperTypeMap.entrySet()) {
            ClassUtils.registerCommonClasses(entry.getKey());
        }
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class);
        ClassUtils.registerOptionalClasses();
        Class[] classArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassUtils.registerCommonClasses(classArray);
        DEFAULT_CLASS_LOADER = null;
        HashSet methods = new HashSet();
        Collections.addAll(methods, "equals", "hashCode", "toString");
        OBJECT_METHODS = Collections.unmodifiableSet(methods);
        try {
            isDefaultMethod = Method.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            isDefaultMethod = null;
        }
        IS_DEFAULT = isDefaultMethod;
    }
}

