/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.util;

import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoadRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import party.iroiro.luajava.LuaNatives;

public class GlobalLibraryLoader {
    private static final SharedLibraryLoader loader = new SharedLibraryLoader();
    private static volatile Class<? extends LuaNatives> loadedNatives = null;
    private static volatile int nativesLoaded = 0;

    private static InputStream readFile(String path) {
        InputStream input = SharedLibraryLoader.class.getResourceAsStream("/" + path);
        if (input == null) {
            throw new SharedLibraryLoadRuntimeException("Unable to read file for extraction: " + path);
        }
        return input;
    }

    public static String load(String libraryName) {
        File[] paths;
        loader.load(libraryName);
        if (SharedLibraryLoader.os == Os.IOS) {
            return "";
        }
        String fileName = loader.mapLibraryName(libraryName);
        if (SharedLibraryLoader.os == Os.Android) {
            return fileName;
        }
        String sourceCrc = loader.crc(GlobalLibraryLoader.readFile(fileName));
        for (File path : paths = new File[]{new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + sourceCrc, fileName)}) {
            try {
                if (!path.exists() || !sourceCrc.equals(loader.crc(new FileInputStream(path)))) continue;
                return path.toString();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        throw new SharedLibraryLoadRuntimeException("Unable to locate the library path");
    }

    public static synchronized void register(Class<? extends LuaNatives> natives, boolean global) {
        if (loadedNatives == null && nativesLoaded == 0) {
            loadedNatives = natives;
            nativesLoaded = global ? 0 : 1;
            return;
        }
        if (global) {
            if (loadedNatives == natives && nativesLoaded == 1) {
                nativesLoaded = 0;
                return;
            }
            throw new SharedLibraryLoadRuntimeException("Library " + loadedNatives.getName() + " already loaded when loading " + natives.getName() + " globally");
        }
        if (loadedNatives != null && nativesLoaded == 0 && loadedNatives != natives) {
            throw new SharedLibraryLoadRuntimeException("Global library " + loadedNatives.getName() + " already loaded when loading " + natives.getName());
        }
        loadedNatives = natives;
        ++nativesLoaded;
    }
}

