/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class LRUCache<K1, K2, V> {
    private final int innerSize;
    private final List<Map<K1, Map<K2, V>>> cacheShards;

    public LRUCache(int level1Size, int level2Size, int shards) {
        this.innerSize = level2Size;
        ArrayList shardList = new ArrayList(shards);
        for (int i = 0; i < shards; ++i) {
            shardList.add(Collections.synchronizedMap(new Cache(level1Size)));
        }
        this.cacheShards = Collections.unmodifiableList(shardList);
    }

    @Nullable
    public V get(K1 k1, K2 k2) {
        Map<K2, V> inner = this.getInnerCache(k1);
        return inner.get(k2);
    }

    private Map<K2, V> getInnerCache(K1 k1) {
        Map<K2, V> prev;
        int shard = k1.hashCode() % this.cacheShards.size();
        Map<K1, Map<K2, Map<K2, V>>> cache = this.cacheShards.get(shard);
        Map<Object, V> inner = cache.get(k1);
        if (inner == null && (prev = cache.putIfAbsent(k1, inner = Collections.synchronizedMap(new Cache(this.innerSize)))) != null) {
            inner = prev;
        }
        return inner;
    }

    public void put(K1 k1, K2 k2, V v) {
        Map<K2, V> inner = this.getInnerCache(k1);
        inner.putIfAbsent(k2, v);
    }

    private static final class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        private Cache(int maxEntries) {
            super(maxEntries + 1, 0.75f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

