/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.util;

import java.lang.reflect.Method;

public abstract class Type {
    public static String getMethodDescriptor(Method method) {
        Class<?>[] parameters;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> parameter : parameters = method.getParameterTypes()) {
            Type.appendDescriptor(parameter, stringBuilder);
        }
        stringBuilder.append(')');
        Type.appendDescriptor(method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            stringBuilder.append(Type.getPrimitiveDescriptor(currentClass));
        } else {
            stringBuilder.append('L').append(Type.getInternalName(currentClass)).append(';');
        }
    }

    public static char getPrimitiveDescriptor(Class<?> currentClass) {
        if (currentClass == Integer.TYPE) {
            return 'I';
        }
        if (currentClass == Void.TYPE) {
            return 'V';
        }
        if (currentClass == Boolean.TYPE) {
            return 'Z';
        }
        if (currentClass == Byte.TYPE) {
            return 'B';
        }
        if (currentClass == Character.TYPE) {
            return 'C';
        }
        if (currentClass == Short.TYPE) {
            return 'S';
        }
        if (currentClass == Double.TYPE) {
            return 'D';
        }
        if (currentClass == Float.TYPE) {
            return 'F';
        }
        if (currentClass == Long.TYPE) {
            return 'J';
        }
        throw new AssertionError();
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }
}

