/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.value;

import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.LuaException;
import party.iroiro.luajava.cleaner.LuaReferable;
import party.iroiro.luajava.value.AbstractLuaValue;
import party.iroiro.luajava.value.LuaValue;

public abstract class AbstractRefLuaValue
extends AbstractLuaValue<Lua>
implements LuaReferable {
    private final int ref;

    public AbstractRefLuaValue(Lua L, Lua.LuaType type) {
        super(L, type);
        this.ref = L.ref();
    }

    @Override
    public void push(Lua L) throws LuaException {
        if (L.getMainState() != this.L.getMainState()) {
            throw new LuaException(LuaException.LuaError.MEMORY, "Unable to pass Lua values between different Lua states");
        }
        L.refGet(this.ref);
    }

    @Override
    @Nullable
    public Object toJavaObject() {
        this.push(this.L);
        Object o = this.L.toObject(-1);
        this.L.pop(1);
        return o;
    }

    @Override
    public int getReference() {
        return this.ref;
    }

    @Override
    @Nullable
    public LuaValue[] call(Object ... parameters) {
        int top = this.L.getTop();
        this.push(this.L);
        for (Object o : parameters) {
            this.L.push(o, Lua.Conversion.SEMI);
        }
        this.L.pCall(parameters.length, -1);
        int returnCount = this.L.getTop() - top;
        LuaValue[] values = new LuaValue[returnCount];
        for (int i = 0; i < returnCount; ++i) {
            values[returnCount - i - 1] = this.L.get();
        }
        return values;
    }
}

