/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.value;

import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.value.AbstractLuaValue;
import party.iroiro.luajava.value.LuaValue;

public abstract class ImmutableLuaValue<T>
extends AbstractLuaValue<Lua> {
    protected final T value;

    protected ImmutableLuaValue(Lua L, Lua.LuaType type, T value) {
        super(L, type);
        this.value = value;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "nil";
        }
        return this.value.toString();
    }

    @Override
    @Nullable
    public Object toJavaObject() {
        return this.value;
    }

    public static LuaValue NIL(Lua L) {
        return new ImmutableLuaValue<Void>(L, Lua.LuaType.NIL, null){

            @Override
            public void push(Lua L) {
                L.pushNil();
            }
        };
    }

    public static LuaValue TRUE(Lua L) {
        return new ImmutableBoolean(L, true);
    }

    public static LuaValue FALSE(Lua L) {
        return new ImmutableBoolean(L, false);
    }

    public static LuaValue NUMBER(Lua L, double n) {
        return new ImmutableNumber(L, n);
    }

    public static LuaValue LONG(Lua L, long n) {
        return new ImmutableLong(L, n);
    }

    public static LuaValue STRING(Lua L, String s) {
        return new ImmutableString(L, s);
    }

    private static class ImmutableString
    extends ImmutableLuaValue<String> {
        private ImmutableString(Lua L, String value) {
            super(L, Lua.LuaType.STRING, value);
        }

        @Override
        public void push(Lua L) {
            L.push((String)this.value);
        }

        @Override
        public int length() {
            return ((String)this.value).length();
        }
    }

    private static class ImmutableLong
    extends ImmutableLuaValue<Long> {
        private ImmutableLong(Lua L, Long value) {
            super(L, Lua.LuaType.NUMBER, value);
        }

        @Override
        public void push(Lua L) {
            L.push((Long)this.value);
        }

        @Override
        @Nullable
        public Object toJavaObject() {
            return ((Long)this.value).doubleValue();
        }
    }

    private static class ImmutableNumber
    extends ImmutableLuaValue<Double> {
        private ImmutableNumber(Lua L, Double value) {
            super(L, Lua.LuaType.NUMBER, value);
        }

        @Override
        public void push(Lua L) {
            L.push((Number)this.value);
        }
    }

    private static class ImmutableBoolean
    extends ImmutableLuaValue<Boolean> {
        private ImmutableBoolean(Lua L, Boolean value) {
            super(L, Lua.LuaType.BOOLEAN, value);
        }

        @Override
        public void push(Lua L) {
            L.push((Boolean)this.value);
        }
    }
}

