/*
 * Decompiled with CFR 0.152.
 */
package party.iroiro.luajava.value;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.value.AbstractRefLuaValue;
import party.iroiro.luajava.value.LuaValue;

public class LuaTableValue
extends AbstractRefLuaValue
implements LuaValue {
    public LuaTableValue(Lua L, Lua.LuaType type) {
        super(L, type);
    }

    @Override
    public int length() {
        Lua L = this.state();
        this.push(L);
        int length = L.rawLength(-1);
        L.pop(1);
        return length;
    }

    @Override
    @NotNull
    public Set<Map.Entry<LuaValue, LuaValue>> entrySet() {
        return new AbstractLuaTableSet();
    }

    @Override
    public boolean containsKey(Object key) {
        Lua L = this.state();
        this.push(L);
        L.push(key, Lua.Conversion.SEMI);
        L.getTable(-2);
        boolean containsKey = !L.isNil(-1);
        L.pop(2);
        return containsKey;
    }

    private LuaValue putRaw(Object key, Object value) {
        Lua L = this.state();
        this.push(L);
        L.push(key, Lua.Conversion.SEMI);
        L.pushValue(-1);
        L.getTable(-3);
        LuaValue old = L.get();
        L.push(value, Lua.Conversion.SEMI);
        L.setTable(-3);
        L.pop(1);
        return old;
    }

    @Override
    public LuaValue remove(Object key) {
        return this.putRaw(key, null);
    }

    @Override
    public LuaValue put(LuaValue key, LuaValue value) {
        return this.putRaw(key, value);
    }

    @Override
    @NotNull
    public LuaValue set(Object key, Object value) {
        return this.putRaw(key, value);
    }

    @Override
    public LuaValue set(int key, Object value) {
        return this.putRaw(key, value);
    }

    @Override
    public LuaValue get(int i) {
        Lua L = this.state();
        this.push(L);
        L.push(i);
        L.getTable(-2);
        LuaValue luaValue = L.get();
        L.pop(1);
        return luaValue;
    }

    @Override
    public LuaValue get(String key) {
        Lua L = this.state();
        this.push(L);
        L.getField(-1, key);
        LuaValue value = L.get();
        L.pop(1);
        return value;
    }

    @Override
    public LuaValue get(LuaValue i) {
        Lua L = this.state();
        this.push(L);
        i.push(L);
        L.getTable(-2);
        LuaValue luaValue = L.get();
        L.pop(1);
        return luaValue;
    }

    @Override
    public LuaValue get(Object key) {
        Lua L = this.state();
        this.push(L);
        L.push(key, Lua.Conversion.SEMI);
        L.getTable(-2);
        LuaValue value = L.get();
        L.pop(1);
        return value;
    }

    protected class AbstractLuaTableSet
    extends AbstractSet<Map.Entry<LuaValue, LuaValue>> {
        protected AbstractLuaTableSet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<LuaValue, LuaValue>> iterator() {
            final Lua L = LuaTableValue.this.state();
            return new Iterator<Map.Entry<LuaValue, LuaValue>>(){
                LuaValue keyRef;
                {
                    this.keyRef = L.fromNull();
                }

                @Override
                public boolean hasNext() {
                    LuaTableValue.this.push(L);
                    this.keyRef.push(L);
                    boolean ended = L.next(-2) == 0;
                    L.pop(ended ? 1 : 3);
                    return !ended;
                }

                @Override
                public Map.Entry<LuaValue, LuaValue> next() {
                    boolean ended;
                    LuaTableValue.this.push(L);
                    this.keyRef.push(L);
                    boolean bl = ended = L.next(-2) == 0;
                    if (ended) {
                        L.pop(1);
                        throw new NoSuchElementException();
                    }
                    LuaValue value = L.get();
                    this.keyRef = L.get();
                    L.pop(1);
                    return new AbstractMap.SimpleEntry<LuaValue, LuaValue>(this.keyRef, value);
                }

                @Override
                public void remove() {
                    if (this.keyRef.type().equals((Object)Lua.LuaType.NIL)) {
                        throw new IllegalStateException();
                    }
                    LuaTableValue.this.push(L);
                    this.keyRef.push(L);
                    L.pushNil();
                    L.setTable(-3);
                    L.pop(1);
                }
            };
        }

        @Override
        public int size() {
            int n = 0;
            Lua L = LuaTableValue.this.state();
            LuaTableValue.this.push(L);
            L.pushNil();
            while (L.next(-2) != 0) {
                ++n;
                L.pop(1);
            }
            L.pop(1);
            return n;
        }
    }
}

