/*
 * Decompiled with CFR 0.152.
 */
package win.templeos.lualink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.Strictness;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class PluginLibrariesLoader
implements PluginLoader {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(RepositoryInfo.class, (Object)RepositoryInfoDeserializer.INSTANCE).setStrictness(Strictness.LENIENT).create();

    public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("paper-libraries.json");){
            if (stream == null) {
                throw new IOException("File 'paper-libraries.json' not found in the classpath.");
            }
            MavenLibraryResolver iLibraries = ((PluginLibraries)this.gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PluginLibraries.class)).toMavenLibraryResolver((Logger)classpathBuilder.getContext().getLogger(), RepositoryContext.INTERNAL);
            classpathBuilder.addLibrary((ClassPathLibrary)iLibraries);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File eLibrariesFile = new File(classpathBuilder.getContext().getDataDirectory().toFile(), "libraries.json");
        if (!eLibrariesFile.exists()) {
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("libraries.json");){
                if (stream == null) {
                    throw new IOException("File 'libraries.json' not found in the classpath.");
                }
                classpathBuilder.getContext().getDataDirectory().toFile().mkdirs();
                Files.copy(stream, eLibrariesFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (eLibrariesFile.exists()) {
            try {
                MavenLibraryResolver eDependencies = ((PluginLibraries)this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(eLibrariesFile), StandardCharsets.UTF_8), PluginLibraries.class)).toMavenLibraryResolver((Logger)classpathBuilder.getContext().getLogger(), RepositoryContext.USER_SPECIFIED);
                classpathBuilder.addLibrary((ClassPathLibrary)eDependencies);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record RepositoryInfo(@NotNull String url, @Nullable String username, @Nullable String password) {
    }

    private static enum RepositoryInfoDeserializer implements JsonDeserializer<RepositoryInfo>
    {
        INSTANCE;


        public RepositoryInfo deserialize(@NotNull JsonElement element, @NotNull Type type, @NotNull JsonDeserializationContext context) throws JsonParseException {
            if (element instanceof JsonPrimitive) {
                return new RepositoryInfo(element.getAsString(), null, null);
            }
            if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                return new RepositoryInfo(object.get("url").getAsString(), object.has("username") ? object.get("username").getAsString() : null, object.has("password") ? object.get("password").getAsString() : null);
            }
            throw new JsonParseException("Invalid repository format.");
        }
    }

    private record PluginLibraries(Map<String, RepositoryInfo> repositories, List<String> dependencies) {
        public MavenLibraryResolver toMavenLibraryResolver(@NotNull Logger logger, @NotNull RepositoryContext context) {
            MavenLibraryResolver resolver = new MavenLibraryResolver();
            this.repositories.entrySet().stream().map(entry -> {
                RemoteRepository.Builder builder;
                try {
                    if (((RepositoryInfo)entry.getValue()).url.contains("maven.org") || ((RepositoryInfo)entry.getValue()).url.contains("maven.apache.org")) {
                        if (context == RepositoryContext.INTERNAL) {
                            builder = new RemoteRepository.Builder((String)entry.getKey(), "default", MavenLibraryResolver.MAVEN_CENTRAL_DEFAULT_MIRROR);
                        } else {
                            logger.warn("Found at least one Maven Central repository in use that was not automatically replaced. Adjust contents of 'libraries.json' to get rid of this warning.");
                            logger.warn("While the plugin should work as usual, please keep in mind that downloading from Maven Central may be against their TOS and can be subject to a rate-limit.");
                            logger.warn("- " + ((RepositoryInfo)entry.getValue()).url + " (" + String.valueOf((Object)context) + ")");
                            builder = new RemoteRepository.Builder((String)entry.getKey(), "default", ((RepositoryInfo)entry.getValue()).url);
                        }
                    } else {
                        builder = new RemoteRepository.Builder((String)entry.getKey(), "default", ((RepositoryInfo)entry.getValue()).url);
                    }
                }
                catch (NoSuchFieldError e) {
                    if (context == RepositoryContext.INTERNAL) {
                        builder = new RemoteRepository.Builder((String)entry.getKey(), "default", "https://maven-central.storage-download.googleapis.com/maven2");
                    }
                    logger.warn("Replacing Maven Central repository with pre-configured mirror failed. As of now, this feature is available only on Paper 1.21.6 #11 and higher.");
                    logger.warn("While the plugin should work as usual, please keep in mind that downloading from Maven Central may be against their TOS and can be subject to a rate-limit.");
                    logger.warn("- " + ((RepositoryInfo)entry.getValue()).url + " (" + String.valueOf((Object)context) + ")");
                    builder = new RemoteRepository.Builder((String)entry.getKey(), "default", ((RepositoryInfo)entry.getValue()).url);
                }
                if (((RepositoryInfo)entry.getValue()).username != null && ((RepositoryInfo)entry.getValue()).password != null) {
                    builder.setAuthentication(new AuthenticationBuilder().addUsername(((RepositoryInfo)entry.getValue()).username).addPassword(((RepositoryInfo)entry.getValue()).password).build());
                }
                return builder.build();
            }).forEach(arg_0 -> ((MavenLibraryResolver)resolver).addRepository(arg_0));
            this.dependencies.stream().map(value -> new Dependency((Artifact)new DefaultArtifact(value), null)).forEach(arg_0 -> ((MavenLibraryResolver)resolver).addDependency(arg_0));
            return resolver;
        }
    }

    private static enum RepositoryContext {
        INTERNAL,
        USER_SPECIFIED;

    }
}

