/*
 * Decompiled with CFR 0.152.
 */
package win.templeos.lualink.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import win.templeos.lualink.config.LuaLinkConfig;
import win.templeos.lualink.config.LuaRuntimes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lwin/templeos/lualink/config/LuaLinkConfigManager;", "", "configFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "gson", "Lcom/google/gson/Gson;", "config", "Lwin/templeos/lualink/config/LuaLinkConfig;", "getConfig", "()Lwin/templeos/lualink/config/LuaLinkConfig;", "setConfig", "(Lwin/templeos/lualink/config/LuaLinkConfig;)V", "loadConfig", "", "saveConfig", "LuaLink"})
public final class LuaLinkConfigManager {
    @NotNull
    private final File configFile;
    @NotNull
    private final Gson gson;
    @NotNull
    private LuaLinkConfig config;

    public LuaLinkConfigManager(@NotNull File configFile) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        this.configFile = configFile;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this.gson = gson;
        this.config = new LuaLinkConfig(LuaRuntimes.LUAJIT);
        this.loadConfig();
    }

    @NotNull
    public final LuaLinkConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull LuaLinkConfig luaLinkConfig) {
        Intrinsics.checkNotNullParameter((Object)luaLinkConfig, (String)"<set-?>");
        this.config = luaLinkConfig;
    }

    private final void loadConfig() {
        if (this.configFile.exists()) {
            try {
                Object object = this.gson.fromJson(FilesKt.readText$default((File)this.configFile, null, (int)1, null), LuaLinkConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                this.config = (LuaLinkConfig)object;
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to load config.json: " + e.getMessage()));
                this.saveConfig();
            }
        } else {
            this.saveConfig();
        }
    }

    public final void saveConfig() {
        try {
            Files.createDirectories(this.configFile.getParentFile().toPath(), new FileAttribute[0]);
            String string = this.gson.toJson((Object)this.config);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)this.configFile, (String)string, null, (int)2, null);
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to save config.json: " + e.getMessage()));
        }
    }
}

