/*
 * Decompiled with CFR 0.152.
 */
package win.templeos.lualink.lua;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import party.iroiro.luajava.Lua;
import party.iroiro.luajava.lua54.Lua54;
import party.iroiro.luajava.luajit.LuaJit;
import party.iroiro.luajava.value.LuaValue;
import win.templeos.lualink.LuaLink;
import win.templeos.lualink.config.LuaRuntimes;
import win.templeos.lualink.lua.LuaCommand;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lwin/templeos/lualink/lua/LuaManager;", "", "plugin", "Lwin/templeos/lualink/LuaLink;", "luaRuntime", "Lwin/templeos/lualink/config/LuaRuntimes;", "<init>", "(Lwin/templeos/lualink/LuaLink;Lwin/templeos/lualink/config/LuaRuntimes;)V", "lua", "Lparty/iroiro/luajava/Lua;", "scriptManagerTable", "Lparty/iroiro/luajava/value/LuaValue;", "loadResourceAsStringByteBuffer", "Ljava/nio/ByteBuffer;", "resourcePath", "", "loadResourceAsString", "loadAllScripts", "", "createScriptFromString", "scriptCode", "scriptName", "close", "getLuaRuntime", "Companion", "LuaLink"})
@SourceDebugExtension(value={"SMAP\nLuaManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuaManager.kt\nwin/templeos/lualink/lua/LuaManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n3919#2:375\n4434#2,2:376\n1878#3,3:378\n*S KotlinDebug\n*F\n+ 1 LuaManager.kt\nwin/templeos/lualink/lua/LuaManager\n*L\n121#1:375\n121#1:376,2\n125#1:378,3\n*E\n"})
public final class LuaManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LuaLink plugin;
    @NotNull
    private final Lua lua;
    @Nullable
    private LuaValue scriptManagerTable;
    @NotNull
    private static final String LUA_SCRIPT_MANAGER_PATH = "/lua/scriptmanager.lua";
    @NotNull
    private static final String LUA_SCRIPT_CLASS_PATH = "/lua/script.lua";
    @NotNull
    private static final String LUA_SCRIPT_PATH = "/lua/lualink.lua";
    @NotNull
    private static final String LUA_SCRIPT_SCHEDULER_PATH = "/lua/scheduler.lua";

    public LuaManager(@NotNull LuaLink plugin, @NotNull LuaRuntimes luaRuntime) {
        Lua lua;
        LuaManager luaManager;
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)((Object)luaRuntime), (String)"luaRuntime");
        this.plugin = plugin;
        LuaManager luaManager2 = this;
        try {
            luaManager = luaManager2;
            lua = switch (WhenMappings.$EnumSwitchMapping$0[luaRuntime.ordinal()]) {
                case 1 -> {
                    this.plugin.getLogger().info("Initializing LuaJIT");
                    yield new LuaJit();
                }
                case 2 -> {
                    this.plugin.getLogger().info("Initializing Lua 5.4");
                    yield new Lua54();
                }
                default -> throw new UnsupportedOperationException("Configured runtime is not LuaJIT or Lua 5.4");
            };
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            luaManager = luaManager2;
            this.plugin.getLogger().warning("LuaJIT failed to load due to missing dependencies (likely libgcc). Falling back to Lua 5.4.");
            lua = new Lua54();
        }
        catch (UnsupportedOperationException e) {
            luaManager = luaManager2;
            lua = new Lua54();
        }
        luaManager.lua = lua;
        this.lua.openLibrary("string");
        this.lua.openLibrary("table");
        this.lua.openLibrary("math");
        this.lua.openLibrary("os");
        this.lua.openLibrary("io");
        this.lua.openLibrary("package");
        this.lua.openLibrary("debug");
        this.lua.pushJavaObject(Bukkit.getServer());
        this.lua.setGlobal("server");
        this.lua.pushJavaObject((Object)this.plugin);
        this.lua.setGlobal("__plugin");
        this.lua.push(arg_0 -> LuaManager._init_$lambda$0(this, arg_0));
        this.lua.setGlobal("__registerCommand");
        this.lua.push(arg_0 -> LuaManager._init_$lambda$1(this, arg_0));
        this.lua.setGlobal("__getAvailableScripts");
        this.lua.push(LuaManager::_init_$lambda$2);
        this.lua.setGlobal("__syncCommands");
        this.lua.push(arg_0 -> LuaManager._init_$lambda$3(this, arg_0));
        this.lua.setGlobal("__createRunnable");
        this.lua.push(LuaManager::_init_$lambda$4);
        this.lua.setGlobal("__ref");
        this.lua.push(LuaManager::_init_$lambda$5);
        this.lua.setGlobal("__unref");
        this.lua.push(arg_0 -> LuaManager._init_$lambda$6(this, arg_0));
        this.lua.setGlobal("__synchronized");
        this.lua.push(LuaManager::_init_$lambda$7);
        this.lua.setGlobal("__exceptionally");
        ByteBuffer scriptCode = this.loadResourceAsStringByteBuffer(LUA_SCRIPT_CLASS_PATH);
        this.lua.load(scriptCode, "script.lua");
        this.lua.pCall(0, 0);
        ByteBuffer schedulerCode = this.loadResourceAsStringByteBuffer(LUA_SCRIPT_SCHEDULER_PATH);
        this.lua.load(schedulerCode, "scheduler.lua");
        this.lua.pCall(0, 0);
        ByteBuffer scriptManagerCode = this.loadResourceAsStringByteBuffer(LUA_SCRIPT_MANAGER_PATH);
        this.lua.load(scriptManagerCode, "scriptmanager.lua");
        this.lua.pCall(0, 0);
        this.scriptManagerTable = this.lua.get("ScriptManager");
        String luaLinkCode = this.loadResourceAsString(LUA_SCRIPT_PATH);
        this.createScriptFromString(luaLinkCode, "LuaLink");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer loadResourceAsStringByteBuffer(String resourcePath) throws IOException {
        Closeable closeable = this.getClass().getResourceAsStream(resourcePath);
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            if (inputStream == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String content = reader.lines().collect(Collectors.joining("\n"));
            Intrinsics.checkNotNull((Object)content);
            String string = content;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byteArray = byArray;
            ByteBuffer buffer = ByteBuffer.allocateDirect(byteArray.length);
            buffer.put(byteArray);
            buffer.flip();
            Intrinsics.checkNotNull((Object)buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String loadResourceAsString(String resourcePath) throws IOException {
        Closeable closeable = this.getClass().getResourceAsStream(resourcePath);
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            if (inputStream == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String string = reader.lines().collect(Collectors.joining("\n"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void loadAllScripts() {
        block0: {
            LuaValue luaValue = this.scriptManagerTable;
            if (luaValue == null || (luaValue = luaValue.get("loadAllScripts")) == null) break block0;
            luaValue.call(new Object[0]);
        }
    }

    private final void createScriptFromString(String scriptCode, String scriptName) {
        LuaValue luaValue = this.scriptManagerTable;
        Intrinsics.checkNotNull((Object)luaValue);
        Object[] objectArray = new Object[]{scriptCode, scriptName};
        luaValue.get("loadScriptFromString").call(objectArray);
    }

    public final void close() {
        LuaValue luaValue = this.scriptManagerTable;
        if (luaValue != null && (luaValue = luaValue.get("unloadAllScripts")) != null) {
            luaValue.call(new Object[0]);
        }
        this.lua.close();
    }

    @NotNull
    public final String getLuaRuntime() {
        Lua lua = this.lua;
        return lua instanceof LuaJit ? "LuaJIT" : (lua instanceof Lua54 ? "Lua 5.4" : "Unknown");
    }

    private static final int _init_$lambda$0(LuaManager this$0, Lua it) {
        LuaValue commandData;
        LuaValue commands;
        if (!it.isString(1)) {
            it.error("Script name is null");
            return 0;
        }
        if (!it.isString(2)) {
            it.error("Command name is null");
            return 0;
        }
        String scriptName = it.toString(1);
        String commandName = it.toString(2);
        if (scriptName == null) {
            it.error("Script name is null");
            return 0;
        }
        if (commandName == null) {
            it.error("Command name is null");
            return 0;
        }
        if (this$0.scriptManagerTable == null) {
            it.error("ScriptManager table is null");
            return 0;
        }
        LuaValue luaValue = this$0.scriptManagerTable;
        Intrinsics.checkNotNull((Object)luaValue);
        Object[] objectArray = new Object[]{scriptName, "script.commands"};
        LuaValue luaValue2 = commands = luaValue.get("getVariable").call(objectArray)[0];
        boolean bl = luaValue2 != null ? luaValue2.size() == 0 : false;
        if (bl) {
            it.error("Commands table is null");
            return 0;
        }
        LuaValue luaValue3 = commands;
        LuaValue luaValue4 = commandData = luaValue3 != null ? luaValue3.get(commandName) : null;
        if (commandData == null) {
            it.error("Command data is null");
            return 0;
        }
        LuaCommand command = new LuaCommand(commandData);
        this$0.plugin.getServer().getCommandMap().register("lualinkscript", (Command)command);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static final int _init_$lambda$1(LuaManager this$0, Lua it) {
        block8: {
            block7: {
                block6: {
                    v0 = this$0.plugin.getDataFolder();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDataFolder(...)");
                    scriptsDir = FilesKt.resolve((File)v0, (String)"scripts");
                    if (!scriptsDir.exists()) {
                        scriptsDir.mkdirs();
                    }
                    v1 = scriptsDir.listFiles();
                    if (v1 == null) break block6;
                    $this$filter$iv = v1;
                    $i$f$filter = false;
                    var7_6 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    var11_11 = ((void)$this$filterTo$iv$iv).length;
                    for (var10_9 = 0; var10_9 < var11_11; ++var10_9) {
                        it = element$iv$iv = $this$filterTo$iv$iv[var10_9];
                        $i$a$-filter-LuaManager$2$scriptFolders$1 = false;
                        if (!it.isDirectory()) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)it);
                        if (FilesKt.resolve((File)it, (String)"main.lua").exists()) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v3 = (List)destination$iv$iv;
                    break block7;
                }
                v3 = null;
            }
            scriptFolders = v3;
            this$0.lua.newTable();
            v4 = scriptFolders;
            if (v4 == null) break block8;
            $this$forEachIndexed$iv = v4;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (E item$iv : $this$forEachIndexed$iv) {
                if ((var9_8 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var10_10 = (File)item$iv;
                index = var9_8;
                $i$a$-forEachIndexed-LuaManager$2$1 = false;
                scriptName = folder.getName();
                this$0.lua.push((Number)(index + 1));
                this$0.lua.push(scriptName);
                this$0.lua.setTable(-3);
            }
        }
        return 1;
    }

    private static final int _init_$lambda$2(Lua it) {
        Bukkit.getServer().getClass().getMethod("syncCommands", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        return 0;
    }

    private static final int _init_$lambda$3(LuaManager this$0, Lua it) {
        if (!it.isFunction(-2)) {
            it.error("Expected a function as the first argument");
            return 0;
        }
        boolean shouldUnref = it.isBoolean(-1) ? it.toBoolean(-1) : false;
        it.pushValue(-2);
        int ref = it.ref();
        BukkitRunnable runnable2 = new BukkitRunnable(this$0, it, ref, shouldUnref){
            final /* synthetic */ LuaManager this$0;
            final /* synthetic */ Lua $it;
            final /* synthetic */ int $ref;
            final /* synthetic */ boolean $shouldUnref;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                this.$ref = $ref;
                this.$shouldUnref = $shouldUnref;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Lua lua = LuaManager.access$getLua$p(this.this$0).getMainState();
                Intrinsics.checkNotNullExpressionValue((Object)lua, (String)"getMainState(...)");
                Lua lua2 = lua;
                Lua lua3 = this.$it;
                int n = this.$ref;
                boolean bl = this.$shouldUnref;
                Lua lua4 = lua2;
                synchronized (lua4) {
                    boolean bl2 = false;
                    lua3.refGet(n);
                    lua3.pushJavaObject((Object)((Object)this));
                    lua3.pCall(1, 0);
                    if (bl) {
                        lua3.unref(n);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            public void cancel() {
                super.cancel();
                this.$it.unref(this.$ref);
            }
        };
        it.pushJavaObject(runnable2);
        it.push((Number)ref);
        return 2;
    }

    private static final int _init_$lambda$4(Lua it) {
        if (!it.isFunction(-1)) {
            it.error("Expected a function as the first argument");
            return 0;
        }
        it.pushValue(-1);
        int ref = it.ref();
        it.push((Number)ref);
        return 1;
    }

    private static final int _init_$lambda$5(Lua it) {
        if (!it.isNumber(-1)) {
            it.error("Expected a number as the first argument");
            return 0;
        }
        double ref = it.toNumber(-1);
        it.unref((int)ref);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int _init_$lambda$6(LuaManager this$0, Lua it) {
        if (it.getTop() == 1) {
            if (!it.isFunction(-1)) {
                it.error("First argument must be a Lua function. Syntax: synchronized(function)");
                return 0;
            }
            Lua lua = this$0.lua.getMainState();
            Intrinsics.checkNotNullExpressionValue((Object)lua, (String)"getMainState(...)");
            Lua lua2 = lua;
            synchronized (lua2) {
                boolean bl = false;
                it.pushValue(-1);
                it.pCall(0, 0);
                Unit unit = Unit.INSTANCE;
            }
            return 0;
        }
        if (!it.isJavaObject(-2)) {
            it.error("First argument must be a Java object. Syntax: synchronized(jobject, function)");
            return 0;
        }
        if (!it.isFunction(-1)) {
            it.error("Second argument must be a Lua function. Syntax: synchronized(jobject, function)");
            return 0;
        }
        Object javaObject = it.toJavaObject(-2);
        if (javaObject != null) {
            Object object = javaObject;
            synchronized (object) {
                boolean bl = false;
                it.pushValue(-1);
                it.pCall(0, 0);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            it.error("First argument must be a non-null Java object. Syntax: synchronized(jobject, function)");
        }
        return 0;
    }

    private static final int _init_$lambda$7(Lua it) {
        if (!it.isFunction(-2)) {
            it.error("First argument must be a Lua function. Syntax: exceptionally(function, function)");
            return 0;
        }
        if (!it.isFunction(-1)) {
            it.error("Second argument must be a Lua function. Syntax: exceptionally(function, function)");
            return 0;
        }
        try {
            it.pushValue(-2);
            it.pCall(0, 0);
        }
        catch (Throwable thr) {
            it.pushValue(-1);
            it.pushJavaObject(thr);
            it.pCall(1, 0);
        }
        return 0;
    }

    public static final /* synthetic */ Lua access$getLua$p(LuaManager $this) {
        return $this.lua;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lwin/templeos/lualink/lua/LuaManager$Companion;", "", "<init>", "()V", "LUA_SCRIPT_MANAGER_PATH", "", "LUA_SCRIPT_CLASS_PATH", "LUA_SCRIPT_PATH", "LUA_SCRIPT_SCHEDULER_PATH", "LuaLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LuaRuntimes.values().length];
            try {
                nArray[LuaRuntimes.LUAJIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LuaRuntimes.LUA54.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

