/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.mixins.EntityAccessor;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    private RenderBuffers renderBuffers;

    @Shadow
    protected abstract void renderEntity(Entity var1, double var2, double var4, double var6, float var8, PoseStack var9, MultiBufferSource var10);

    @Inject(method={"renderEntities(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/Camera;Lnet/minecraft/client/DeltaTracker;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private void renderEntities(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Camera camera, DeltaTracker deltaTracker, List<Entity> list, CallbackInfo ci) {
        PoseStack matrices = new PoseStack();
        if (camera.isDetached() || !FirstPersonModelCore.instance.getLogicHandler().shouldApplyThirdPerson(false)) {
            return;
        }
        Vec3 vec3d = camera.getPosition();
        MultiBufferSource.BufferSource immediate = this.renderBuffers.bufferSource();
        FirstPersonModelCore.instance.setRenderingPlayer(true);
        FirstPersonModelCore.instance.setRenderingPlayerPost(true);
        Entity ent = camera.getEntity();
        Vec3 pos = ((EntityAccessor)ent).entityCulling$getRawPosition();
        double xO = ent.xo;
        double yO = ent.yo;
        double zO = ent.zo;
        double xOld = ent.xOld;
        double yOld = ent.yOld;
        double zOld = ent.zOld;
        float tickDelta = deltaTracker.getGameTimeDeltaPartialTick(true);
        FirstPersonModelCore.instance.getLogicHandler().updatePositionOffset(ent, tickDelta);
        Vec3 offset = FirstPersonModelCore.instance.getLogicHandler().getOffset();
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos.add(offset));
        ent.xo += offset.x;
        ent.yo += offset.y;
        ent.zo += offset.z;
        ent.xOld += offset.x;
        ent.yOld += offset.y;
        ent.zOld += offset.z;
        FirstPersonModelCore.instance.getLogicHandler().updatePositionOffset(ent, deltaTracker.getGameTimeDeltaPartialTick(true));
        this.renderEntity(camera.getEntity(), vec3d.x(), vec3d.y(), vec3d.z(), deltaTracker.getGameTimeDeltaPartialTick(false), matrices, (MultiBufferSource)immediate);
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos);
        ent.xo = xO;
        ent.yo = yO;
        ent.zo = zO;
        ent.xOld = xOld;
        ent.yOld = yOld;
        ent.zOld = zOld;
        FirstPersonModelCore.instance.setRenderingPlayer(false);
        FirstPersonModelCore.instance.setRenderingPlayerPost(false);
    }
}

