/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.mixins.EntityAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    private RenderBuffers renderBuffers;

    @Shadow
    protected abstract void renderEntity(Entity var1, double var2, double var4, double var6, float var8, PoseStack var9, MultiBufferSource var10);

    @Inject(method={"renderLevel(FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    public void render(float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo info) {
        PoseStack matrices = new PoseStack();
        if (camera.isDetached() || !FirstPersonModelCore.instance.getLogicHandler().shouldApplyThirdPerson(false)) {
            return;
        }
        Vec3 vec3d = camera.getPosition();
        MultiBufferSource.BufferSource immediate = this.renderBuffers.bufferSource();
        FirstPersonModelCore.instance.setRenderingPlayer(true);
        FirstPersonModelCore.instance.setRenderingPlayerPost(true);
        Entity ent = camera.getEntity();
        Vec3 pos = ((EntityAccessor)ent).entityCulling$getRawPosition();
        double xO = ent.xo;
        double yO = ent.yo;
        double zO = ent.zo;
        double xOld = ent.xOld;
        double yOld = ent.yOld;
        double zOld = ent.zOld;
        FirstPersonModelCore.instance.getLogicHandler().updatePositionOffset(ent, tickDelta);
        Vec3 offset = FirstPersonModelCore.instance.getLogicHandler().getOffset();
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos.add(offset));
        ent.xo += offset.x;
        ent.yo += offset.y;
        ent.zo += offset.z;
        ent.xOld += offset.x;
        ent.yOld += offset.y;
        ent.zOld += offset.z;
        this.renderEntity(camera.getEntity(), vec3d.x(), vec3d.y(), vec3d.z(), tickDelta, matrices, (MultiBufferSource)immediate);
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos);
        ent.xo = xO;
        ent.yo = yO;
        ent.zo = zO;
        ent.xOld = xOld;
        ent.yOld = yOld;
        ent.zOld = zOld;
        FirstPersonModelCore.instance.setRenderingPlayer(false);
        FirstPersonModelCore.instance.setRenderingPlayerPost(false);
    }
}

