/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import dev.tr7zw.firstperson.LogicHandler;
import dev.tr7zw.firstperson.access.PlayerRendererAccess;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.config.ConfigScreenProvider;
import dev.tr7zw.firstperson.forge.RenderHandEventListener;
import dev.tr7zw.firstperson.modsupport.ModSupportLoader;
import dev.tr7zw.firstperson.modsupport.PlayerAnimatorSupport;
import dev.tr7zw.firstperson.versionless.FirstPersonBase;
import dev.tr7zw.transition.loader.ModLoaderEventUtil;
import dev.tr7zw.transition.loader.ModLoaderUtil;
import lombok.Generated;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderHandEvent;

public abstract class FirstPersonModelCore
extends FirstPersonBase {
    private LogicHandler logicHandler;
    public static FirstPersonModelCore instance;
    private boolean isHeld = false;
    private KeyMapping keyBinding = new KeyMapping("key.firstperson.toggle", 295, new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"firstperson", (String)"keybind")));
    private boolean lateInit = true;
    @Deprecated
    public static boolean enabled;
    @Deprecated
    public static boolean isRenderingPlayer;
    private CameraType lastCameraType = null;

    protected FirstPersonModelCore() {
        instance = this;
    }

    public void sharedSetup() {
        LOGGER.info("Loading FirstPerson Mod");
        this.logicHandler = new LogicHandler(Minecraft.getInstance(), this);
        super.loadConfig();
        ModLoaderUtil.registerKeybind((KeyMapping)this.keyBinding);
        ModLoaderEventUtil.registerClientTickStartListener(this::onTick);
        ModLoaderUtil.disableDisplayTest();
        ModLoaderUtil.registerConfigScreen(ConfigScreenProvider::createConfigScreen);
        RenderHandEvent.BUS.addListener(new RenderHandEventListener()::onRender);
        ModSupportLoader.loadSupport();
    }

    private void lateInit() {
        try {
            if (FirstPersonModelCore.isValidClass("dev.kosmx.playerAnim.core.impl.AnimationProcessor")) {
                LOGGER.info("Loading PlayerAnimator support!");
                FirstPersonAPI.registerPlayerHandler(new PlayerAnimatorSupport());
            } else {
                LOGGER.info("PlayerAnimator not found!");
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Error during initialization of mod support.", ex);
        }
        this.logicHandler.registerDefaultHandlers();
        this.logicHandler.reloadAutoVanillaHandsSettings();
        this.updatePlayerLayers();
    }

    public void onTick() {
        if (this.lateInit) {
            this.lateInit = false;
            this.lateInit();
        }
        if (this.keyBinding.isDown()) {
            if (this.isHeld) {
                return;
            }
            this.isHeld = true;
            this.setEnabled(!this.isEnabled());
        } else {
            this.isHeld = false;
        }
    }

    @Override
    public void setRenderingPlayer(boolean isRenderingPlayer) {
        super.setRenderingPlayer(isRenderingPlayer);
        FirstPersonModelCore.isRenderingPlayer = isRenderingPlayer;
        if (this.lastCameraType != Minecraft.getInstance().options.getCameraType()) {
            this.lastCameraType = Minecraft.getInstance().options.getCameraType();
            this.updatePlayerLayers();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        FirstPersonModelCore.enabled = enabled;
    }

    public void updatePlayerLayers() {
        PlayerRendererAccess access = null;
        access = (PlayerRendererAccess)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((EntityRenderState)new AvatarRenderState());
        if (access != null) {
            access.updatePartsList(this.lastCameraType != CameraType.FIRST_PERSON);
        }
    }

    @Generated
    public LogicHandler getLogicHandler() {
        return this.logicHandler;
    }

    static {
        enabled = true;
        isRenderingPlayer = false;
    }
}

