/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.config;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.access.PlayerRendererAccess;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.transition.mc.ItemUtil;
import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.client.AbstractConfigScreen;
import dev.tr7zw.trender.gui.client.BackgroundPainter;
import dev.tr7zw.trender.gui.widget.WButton;
import dev.tr7zw.trender.gui.widget.WGridPanel;
import dev.tr7zw.trender.gui.widget.WListPanel;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WTabPanel;
import dev.tr7zw.trender.gui.widget.WTextField;
import dev.tr7zw.trender.gui.widget.WToggleButton;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.Insets;
import dev.tr7zw.trender.gui.widget.icon.Icon;
import dev.tr7zw.trender.gui.widget.icon.ItemIcon;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class ConfigScreenProvider {
    public static Screen createConfigScreen(Screen parent) {
        return new CustomConfigScreen(parent).createScreen();
    }

    @Generated
    private ConfigScreenProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class CustomConfigScreen
    extends AbstractConfigScreen {
        public CustomConfigScreen(Screen previous) {
            super((Component)ComponentProvider.translatable((String)"text.firstperson.title"), previous);
            WGridPanel root = new WGridPanel(8);
            root.setInsets(Insets.ROOT_PANEL);
            this.setRootPanel((WPanel)root);
            WTabPanel wTabPanel = new WTabPanel();
            ArrayList<AbstractConfigScreen.OptionInstance> options = new ArrayList<AbstractConfigScreen.OptionInstance>();
            options.add(this.getIntOption("text.firstperson.option.firstperson.xOffset", -40, 40, () -> FirstPersonModelCore.instance.getConfig().xOffset, i -> {
                FirstPersonModelCore.instance.getConfig().xOffset = i;
            }));
            options.add(this.getIntOption("text.firstperson.option.firstperson.sneakXOffset", -40, 40, () -> FirstPersonModelCore.instance.getConfig().sneakXOffset, i -> {
                FirstPersonModelCore.instance.getConfig().sneakXOffset = i;
            }));
            options.add(this.getIntOption("text.firstperson.option.firstperson.sitXOffset", -40, 40, () -> FirstPersonModelCore.instance.getConfig().sitXOffset, i -> {
                FirstPersonModelCore.instance.getConfig().sitXOffset = i;
            }));
            options.add(this.getOnOffOption("text.firstperson.option.firstperson.renderStuckFeatures", () -> FirstPersonModelCore.instance.getConfig().renderStuckFeatures, b -> {
                FirstPersonModelCore.instance.getConfig().renderStuckFeatures = b;
            }));
            options.add(this.getEnumOption("text.firstperson.option.firstperson.vanillaHandMode", VanillaHands.class, () -> FirstPersonModelCore.instance.getConfig().vanillaHandsMode, b -> {
                FirstPersonModelCore.instance.getConfig().vanillaHandsMode = b;
            }));
            options.add(this.getOnOffOption("text.firstperson.option.firstperson.dynamicMode", () -> FirstPersonModelCore.instance.getConfig().dynamicMode, b -> {
                FirstPersonModelCore.instance.getConfig().dynamicMode = b;
            }));
            options.add(this.getOnOffOption("text.firstperson.option.firstperson.vanillaHandsSkipSwimming", () -> FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming, b -> {
                FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming = b;
            }));
            WListPanel optionList = this.createOptionList(options);
            optionList.setGap(-1);
            optionList.setSize(280, 180);
            wTabPanel.add((WWidget)optionList, b -> b.title((Component)ComponentProvider.translatable((String)"text.firstperson.tab.settings")).icon((Icon)new ItemIcon(Items.COMPARATOR)));
            ArrayList items = new ArrayList(ItemUtil.getItems());
            items.sort((a, b) -> ((ResourceKey)a.getKey()).location().toString().compareTo(((ResourceKey)b.getKey()).location().toString()));
            WListPanel itemList = new WListPanel(items, () -> new WToggleButton(ComponentProvider.EMPTY), (s, l) -> {
                l.setLabel(((Item)s.getValue()).getName(((Item)s.getValue()).getDefaultInstance()));
                l.setToolip((Component)ComponentProvider.literal((String)((ResourceKey)s.getKey()).location().toString()));
                l.setIcon((Icon)new ItemIcon((Item)s.getValue()));
                l.setToggle(FirstPersonModelCore.instance.getConfig().autoVanillaHands.contains(((ResourceKey)s.getKey()).location().toString()));
                l.setOnToggle(b -> {
                    if (b.booleanValue()) {
                        FirstPersonModelCore.instance.getConfig().autoVanillaHands.add(((ResourceKey)s.getKey()).location().toString());
                    } else {
                        FirstPersonModelCore.instance.getConfig().autoVanillaHands.remove(((ResourceKey)s.getKey()).location().toString());
                    }
                    FirstPersonModelCore.instance.getLogicHandler().reloadAutoVanillaHandsSettings();
                    this.save();
                });
            });
            itemList.setGap(-1);
            itemList.setInsets(new Insets(2, 4));
            WGridPanel itemTab = new WGridPanel(20);
            itemTab.add((WWidget)itemList, 0, 0, 17, 7);
            WTextField searchField = new WTextField();
            searchField.setChangedListener(s -> {
                itemList.setFilter(e -> ((ResourceKey)e.getKey()).location().toString().toLowerCase().contains(s.toLowerCase()));
                itemList.layout();
            });
            itemTab.add((WWidget)searchField, 0, 7, 17, 1);
            wTabPanel.add((WWidget)itemTab, b -> b.title((Component)ComponentProvider.translatable((String)"text.firstperson.tab.autovanillahands")).icon((Icon)new ItemIcon(Items.FILLED_MAP)));
            WListPanel disableList = new WListPanel(items, () -> new WToggleButton(ComponentProvider.EMPTY), (s, l) -> {
                l.setLabel(((Item)s.getValue()).getName(((Item)s.getValue()).getDefaultInstance()));
                l.setToolip((Component)ComponentProvider.literal((String)((ResourceKey)s.getKey()).location().toString()));
                l.setIcon((Icon)new ItemIcon((Item)s.getValue()));
                l.setToggle(FirstPersonModelCore.instance.getConfig().autoToggleModItems.contains(((ResourceKey)s.getKey()).location().toString()));
                l.setOnToggle(b -> {
                    if (b.booleanValue()) {
                        FirstPersonModelCore.instance.getConfig().autoToggleModItems.add(((ResourceKey)s.getKey()).location().toString());
                    } else {
                        FirstPersonModelCore.instance.getConfig().autoToggleModItems.remove(((ResourceKey)s.getKey()).location().toString());
                    }
                    FirstPersonModelCore.instance.getLogicHandler().reloadAutoVanillaHandsSettings();
                    this.save();
                });
            });
            disableList.setGap(-1);
            disableList.setInsets(new Insets(2, 4));
            WGridPanel disableTab = new WGridPanel(20);
            disableTab.add((WWidget)disableList, 0, 0, 17, 7);
            WTextField searchDisableField = new WTextField();
            searchDisableField.setChangedListener(s -> {
                disableList.setFilter(e -> ((ResourceKey)e.getKey()).location().toString().toLowerCase().contains(s.toLowerCase()));
                disableList.layout();
            });
            disableTab.add((WWidget)searchDisableField, 0, 7, 17, 1);
            wTabPanel.add((WWidget)disableTab, b -> b.title((Component)ComponentProvider.translatable((String)"text.firstperson.tab.disableitems")).icon((Icon)new ItemIcon(Items.BARRIER)));
            PlayerRendererAccess access = null;
            access = (PlayerRendererAccess)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((EntityRenderState)new AvatarRenderState());
            if (access != null) {
                WListPanel layerList = new WListPanel(access.getRenderLayers(), () -> new WToggleButton(ComponentProvider.EMPTY), (s, l) -> {
                    l.setLabel((Component)ComponentProvider.literal((String)s.getClass().getSimpleName()));
                    l.setToolip((Component)ComponentProvider.literal((String)s.getClass().getName()));
                    l.setToggle(!FirstPersonModelCore.instance.getConfig().hiddenLayers.contains(s.getClass().getName()));
                    l.setOnToggle(b -> {
                        if (b.booleanValue()) {
                            FirstPersonModelCore.instance.getConfig().hiddenLayers.remove(s.getClass().getName());
                        } else {
                            FirstPersonModelCore.instance.getConfig().hiddenLayers.add(s.getClass().getName());
                        }
                        this.save();
                        FirstPersonModelCore.instance.updatePlayerLayers();
                    });
                });
                layerList.setGap(-1);
                layerList.setInsets(new Insets(2, 4));
                WGridPanel layerTab = new WGridPanel(20);
                layerTab.add((WWidget)layerList, 0, 0, 17, 7);
                WTextField searchLayerField = new WTextField();
                searchLayerField.setChangedListener(s -> {
                    layerList.setFilter(e -> e.getClass().getName().toLowerCase().contains(s.toLowerCase()));
                    layerList.layout();
                });
                layerTab.add((WWidget)searchLayerField, 0, 7, 17, 1);
                wTabPanel.add((WWidget)layerTab, b -> b.title((Component)ComponentProvider.translatable((String)"text.firstperson.tab.layers")).icon((Icon)new ItemIcon(Items.NETHERITE_HELMET)));
            }
            wTabPanel.layout();
            root.add((WWidget)wTabPanel, 0, 2);
            WButton doneButton = new WButton(CommonComponents.GUI_DONE);
            doneButton.setOnClick(() -> {
                this.save();
                Minecraft.getInstance().setScreen(previous);
            });
            root.add((WWidget)doneButton, 0, 27, 6, 2);
            WButton resetButton = new WButton((Component)ComponentProvider.translatable((String)"controls.reset"));
            resetButton.setOnClick(() -> {
                this.reset();
                root.layout();
            });
            root.add((WWidget)resetButton, 37, 27, 6, 2);
            root.setBackgroundPainter(BackgroundPainter.VANILLA);
            root.validate((GuiDescription)this);
            root.setHost((GuiDescription)this);
        }

        public void reset() {
            FirstPersonModelCore.instance.resetSettings();
            FirstPersonModelCore.instance.writeSettings();
        }

        public void save() {
            FirstPersonModelCore.instance.writeSettings();
        }
    }
}

