/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import dev.tr7zw.firstperson.access.LivingEntityRenderStateAccess;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart head;
    @Shadow
    @Final
    public ModelPart body;

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"}, at={@At(value="TAIL")})
    private void setupAnim(HumanoidRenderState renderState, CallbackInfo ci) {
        LivingEntityRenderStateAccess access;
        if (renderState instanceof AvatarRenderState) {
            AvatarRenderState avatarRenderState = (AvatarRenderState)renderState;
            if (avatarRenderState.isSpectator) {
                this.head.visible = true;
                return;
            }
        }
        this.head.visible = !(access = (LivingEntityRenderStateAccess)renderState).isCameraEntity();
        this.leftArm.visible = !access.hideLeftArm();
        this.leftArm.xRot += access.getArmOffset();
        this.rightArm.visible = !access.hideRightArm();
        this.rightArm.xRot += access.getArmOffset();
        this.body.visible = !access.hideBody();
    }
}

