/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.access.LivingEntityRenderStateAccess;
import dev.tr7zw.firstperson.access.PlayerRendererAccess;
import dev.tr7zw.transition.mc.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AvatarRenderer.class}, priority=500)
public abstract class PlayerRendererMixin
extends LivingEntityRenderer
implements PlayerRendererAccess {
    private static Minecraft fpmMcInstance = Minecraft.getInstance();
    private List<RenderLayer> removedLayers = new ArrayList<RenderLayer>();

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="TAIL")})
    public void extractRenderState(Avatar avatar, AvatarRenderState avatarRenderState, float delta, CallbackInfo ci) {
        LivingEntityRenderStateAccess access = (LivingEntityRenderStateAccess)avatarRenderState;
        if (!access.isCameraEntity()) {
            return;
        }
        if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems((LivingEntity)avatar)) {
            access.setHideArms(true);
        } else if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled()) {
            access.setArmOffset(Mth.clamp((float)(-EntityUtil.getXRot((Entity)avatar) / 20.0f + 2.0f), (float)-0.0f, (float)0.7f));
            if (!FirstPersonModelCore.instance.getLogicHandler().lookingDown((LivingEntity)avatar)) {
                if (!avatar.getOffhandItem().isEmpty() || avatar.getMainHandItem().getItem().equals(Items.FILLED_MAP)) {
                    access.setHideLeftArm(true);
                }
                if (!avatar.getMainHandItem().isEmpty()) {
                    access.setHideRightArm(true);
                }
            }
        }
        if (avatar.isSwimming()) {
            access.setHideBody(true);
            avatarRenderState.showCape = false;
        }
        if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems((LivingEntity)avatar, avatar.getMainHandItem(), avatar.getOffhandItem())) {
            access.setHideArms(true);
        }
        avatarRenderState.hitboxesRenderState = null;
    }

    @Override
    public List<RenderLayer> getRenderLayers() {
        ArrayList<RenderLayer> layers = new ArrayList<RenderLayer>(this.layers);
        layers.addAll(this.removedLayers);
        return layers;
    }

    @Override
    public void updatePartsList(boolean thirdperson) {
        this.layers.addAll(this.removedLayers);
        this.removedLayers.clear();
        if (thirdperson) {
            return;
        }
        for (Object layerObj : this.layers) {
            RenderLayer layer = (RenderLayer)layerObj;
            if (!FirstPersonModelCore.instance.getConfig().hiddenLayers.contains(layer.getClass().getName())) continue;
            this.removedLayers.add(layer);
        }
        this.layers.removeAll(this.removedLayers);
    }
}

