/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.mixins.EntityAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    private RenderBuffers renderBuffers;

    @Shadow
    protected abstract EntityRenderState extractEntity(Entity var1, float var2);

    @Inject(method={"extractVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/DeltaTracker;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"}, at={@At(value="HEAD")})
    private void renderEntities(Camera camera, Frustum frustum, DeltaTracker deltaTracker, LevelRenderState levelRenderState, CallbackInfo ci) {
        PoseStack matrices = new PoseStack();
        if (camera.isDetached() || !FirstPersonModelCore.instance.getLogicHandler().shouldApplyThirdPerson(false)) {
            return;
        }
        Vec3 vec3d = camera.getPosition();
        MultiBufferSource.BufferSource immediate = this.renderBuffers.bufferSource();
        FirstPersonModelCore.instance.setRenderingPlayer(true);
        FirstPersonModelCore.instance.setRenderingPlayerPost(true);
        Entity ent = camera.getEntity();
        Vec3 pos = ((EntityAccessor)ent).entityCulling$getRawPosition();
        double xO = ent.xo;
        double yO = ent.yo;
        double zO = ent.zo;
        double xOld = ent.xOld;
        double yOld = ent.yOld;
        double zOld = ent.zOld;
        float tickDelta = deltaTracker.getGameTimeDeltaPartialTick(true);
        FirstPersonModelCore.instance.getLogicHandler().updatePositionOffset(ent, tickDelta);
        Vec3 offset = FirstPersonModelCore.instance.getLogicHandler().getOffset();
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos.add(offset));
        ent.xo += offset.x;
        ent.yo += offset.y;
        ent.zo += offset.z;
        ent.xOld += offset.x;
        ent.yOld += offset.y;
        ent.zOld += offset.z;
        levelRenderState.entityRenderStates.add(this.extractEntity(ent, deltaTracker.getGameTimeDeltaPartialTick(true)));
        ((EntityAccessor)ent).entityCulling$setRawPosition(pos);
        ent.xo = xO;
        ent.yo = yO;
        ent.zo = zO;
        ent.xOld = xOld;
        ent.yOld = yOld;
        ent.zOld = zOld;
        FirstPersonModelCore.instance.setRenderingPlayer(false);
        FirstPersonModelCore.instance.setRenderingPlayerPost(false);
    }
}

