/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.versionless;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.firstperson.versionless.config.ConfigUpgrader;
import dev.tr7zw.firstperson.versionless.config.FirstPersonSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FirstPersonBase {
    public static final Logger LOGGER = LogManager.getLogger((String)"FirstPersonModel");
    private boolean isRenderingPlayer = false;
    private boolean isRenderingPlayerPost = false;
    private boolean enabled = true;
    private FirstPersonSettings config = null;
    private File settingsFile = new File("config", "firstperson.json");

    public void loadConfig() {
        if (this.settingsFile.exists()) {
            try {
                this.config = (FirstPersonSettings)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), FirstPersonSettings.class);
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to load the config, creating a new one.", (Throwable)ex);
            }
        }
        if (this.config == null) {
            this.config = new FirstPersonSettings();
        }
        ConfigUpgrader.upgradeConfig(this.config);
        this.writeSettings();
        this.setEnabled(this.config.enabledByDefault);
    }

    public void writeSettings() {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)this.config);
        try {
            Files.write(this.settingsFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Error while saving the config!", (Throwable)e);
        }
    }

    public void resetSettings() {
        this.config = new FirstPersonSettings();
    }

    protected static boolean isValidClass(String name) {
        try {
            if (Class.forName(name) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isRenderingPlayer() {
        return this.isRenderingPlayer;
    }

    public void setRenderingPlayer(boolean isRenderingPlayer) {
        this.isRenderingPlayer = isRenderingPlayer;
    }

    public boolean isRenderingPlayerPost() {
        return this.isRenderingPlayerPost;
    }

    public void setRenderingPlayerPost(boolean isRenderingPlayerPost) {
        this.isRenderingPlayerPost = isRenderingPlayerPost;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public FirstPersonSettings getConfig() {
        return this.config;
    }
}

