/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.InventoryUtil;
import dev.tr7zw.firstperson.access.AgeableListModelAccess;
import dev.tr7zw.firstperson.versionless.mixinbase.ModelPartBase;
import dev.tr7zw.transition.mc.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin {
    private static List<Runnable> revert = new ArrayList<Runnable>();

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void render(LivingEntityRenderState livingEntityRenderState, PoseStack matrixStack, MultiBufferSource multiBufferSource, int i, CallbackInfo info) {
        float offset;
        Player player;
        if (!FirstPersonModelCore.instance.isRenderingPlayer()) {
            return;
        }
        Entity entity = Minecraft.getInstance().cameraEntity;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!revert.isEmpty()) {
            for (Runnable r : revert) {
                r.run();
            }
            revert.clear();
        }
        if (!FirstPersonModelCore.instance.isRenderingPlayer()) {
            return;
        }
        if (livingEntity instanceof Shulker) {
            return;
        }
        EntityModel model = this.getModel();
        boolean headShouldBeHidden = false;
        if (model instanceof AgeableListModelAccess) {
            AgeableListModelAccess agable = (AgeableListModelAccess)model;
            agable.firstPersonHeadPartsGetter().forEach(part -> {
                ((ModelPartBase)part).setHidden();
                revert.add(() -> ((ModelPartBase)part).showAgain());
            });
            headShouldBeHidden = true;
        }
        if (model instanceof HeadedModel) {
            HeadedModel headed = (HeadedModel)model;
            ((ModelPartBase)headed.getHead()).setHidden();
            revert.add(() -> ((ModelPartBase)headed.getHead()).showAgain());
            headShouldBeHidden = true;
        }
        if (model instanceof HumanoidModel) {
            HumanoidModel humanModel = (HumanoidModel)model;
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems(livingEntity)) {
                    ((ModelPartBase)humanModel.leftArm).setHidden();
                    ((ModelPartBase)humanModel.rightArm).setHidden();
                    revert.add(() -> {
                        ((ModelPartBase)humanModel.leftArm).showAgain();
                        ((ModelPartBase)humanModel.rightArm).showAgain();
                    });
                } else if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled()) {
                    offset = Mth.clamp((float)(-EntityUtil.getXRot((Entity)Minecraft.getInstance().player) / 20.0f + 2.0f), (float)-0.0f, (float)0.7f);
                    humanModel.rightArm.xRot += offset;
                    humanModel.leftArm.xRot += offset;
                    if (!FirstPersonModelCore.instance.getLogicHandler().lookingDown()) {
                        if (!InventoryUtil.getOffhand(InventoryUtil.getInventory(player)).isEmpty() || livingEntity.getMainHandItem().getItem().equals(Items.FILLED_MAP)) {
                            ((ModelPartBase)humanModel.leftArm).setHidden();
                            revert.add(() -> ((ModelPartBase)humanModel.leftArm).showAgain());
                        }
                        if (!InventoryUtil.getSelected(InventoryUtil.getInventory(player)).isEmpty()) {
                            ((ModelPartBase)humanModel.rightArm).setHidden();
                            revert.add(() -> ((ModelPartBase)humanModel.rightArm).showAgain());
                        }
                    }
                }
            }
        }
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            headShouldBeHidden = true;
            ((ModelPartBase)playerModel.hat).setHidden();
            revert.add(() -> ((ModelPartBase)playerModel.hat).showAgain());
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems(livingEntity)) {
                    ((ModelPartBase)playerModel.leftSleeve).setHidden();
                    ((ModelPartBase)playerModel.rightSleeve).setHidden();
                    revert.add(() -> {
                        ((ModelPartBase)playerModel.leftSleeve).showAgain();
                        ((ModelPartBase)playerModel.rightSleeve).showAgain();
                    });
                } else if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled()) {
                    offset = Mth.clamp((float)(-EntityUtil.getXRot((Entity)Minecraft.getInstance().player) / 20.0f + 2.0f), (float)-0.0f, (float)0.7f);
                    playerModel.rightSleeve.xRot += offset;
                    playerModel.leftSleeve.xRot += offset;
                    if (!FirstPersonModelCore.instance.getLogicHandler().lookingDown()) {
                        if (!InventoryUtil.getOffhand(InventoryUtil.getInventory(player)).isEmpty() || livingEntity.getMainHandItem().getItem().equals(Items.FILLED_MAP)) {
                            ((ModelPartBase)playerModel.leftSleeve).setHidden();
                            revert.add(() -> ((ModelPartBase)playerModel.leftSleeve).showAgain());
                        }
                        if (!InventoryUtil.getSelected(InventoryUtil.getInventory(player)).isEmpty()) {
                            ((ModelPartBase)playerModel.rightSleeve).setHidden();
                            revert.add(() -> ((ModelPartBase)playerModel.rightSleeve).showAgain());
                        }
                    }
                }
            }
        }
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player2 = (AbstractClientPlayer)livingEntity;
            EntityModel offset2 = model;
            if (offset2 instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)offset2;
                if (FirstPersonModelCore.instance.getLogicHandler().isSwimming((Player)player2)) {
                    ((ModelPartBase)playerModel.body).setHidden();
                    if (livingEntityRenderState instanceof PlayerRenderState) {
                        PlayerRenderState prs = (PlayerRenderState)livingEntityRenderState;
                        prs.showCape = false;
                    }
                    revert.add(() -> ((ModelPartBase)playerModel.body).showAgain());
                }
            }
        }
        if (!headShouldBeHidden) {
            matrixStack.popPose();
            info.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    public void renderEnd(LivingEntityRenderState livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo info) {
        if (!revert.isEmpty()) {
            for (Runnable r : revert) {
                r.run();
            }
            revert.clear();
        }
        FirstPersonModelCore.instance.setRenderingPlayer(false);
    }

    @Shadow
    public abstract EntityModel getModel();
}

