/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.InventoryUtil;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.api.PlayerOffsetHandler;
import dev.tr7zw.firstperson.versionless.FirstPersonBase;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import dev.tr7zw.transition.mc.EntityUtil;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.ItemUtil;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class LogicHandler {
    private final Minecraft client;
    private final FirstPersonModelCore fpm;
    private Vec3 offset = Vec3.ZERO;
    private Set<Item> autoVanillaHandItems = new HashSet<Item>();
    private Set<Item> autoDisableItems = new HashSet<Item>();
    private long timeout = 0L;

    void registerDefaultHandlers() {
        FirstPersonAPI.registerPlayerHandler(() -> {
            if (this.client.player.isSleeping() || this.client.player.isAutoSpinAttack() || this.client.player.isFallFlying() || this.client.player.getSwimAmount(1.0f) != 0.0f && !this.isCrawlingOrSwimming((Player)this.client.player)) {
                this.timeout = System.currentTimeMillis() + 100L;
                return true;
            }
            if (System.currentTimeMillis() < this.timeout) {
                return true;
            }
            if (this.autoDisableItems.contains(this.client.player.getMainHandItem().getItem()) || this.autoDisableItems.contains(this.client.player.getOffhandItem().getItem())) {
                return true;
            }
            return this.client.player.isScoping();
        });
    }

    public boolean shouldApplyThirdPerson(boolean thirdPerson) {
        if (!this.fpm.isEnabled() || thirdPerson) {
            return false;
        }
        for (ActivationHandler handler : FirstPersonAPI.getActivationHandlers()) {
            if (!handler.preventFirstperson()) continue;
            return false;
        }
        return true;
    }

    public void updatePositionOffset(Entity entity, float delta) {
        this.offset = Vec3.ZERO;
        if (entity == this.client.getCameraEntity() && this.client.player.isSleeping()) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.client.options.getCameraType() != CameraType.FIRST_PERSON) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            double realYaw = Mth.rotLerp((float)delta, (float)player.yBodyRotO, (float)player.yBodyRot);
            if (this.client.getCameraEntity() == player) {
                float bodyOffset;
                if (this.isCrawlingOrSwimming((Player)this.client.player)) {
                    player.yBodyRot = player.yHeadRot;
                    bodyOffset = player.xRotO > 0.0f ? 0.6f : 0.5f;
                } else if (player.isCrouching() || player.getPose() == Pose.CROUCHING) {
                    bodyOffset = 0.27f + (float)this.fpm.getConfig().sneakXOffset / 100.0f;
                } else if (player.isPassenger()) {
                    if (player.getVehicle() instanceof Boat || player.getVehicle() instanceof Minecart) {
                        realYaw = Mth.rotLerp((float)delta, (float)player.yBodyRotO, (float)player.yBodyRot);
                    } else {
                        Entity entity2 = player.getVehicle();
                        if (entity2 instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)entity2;
                            realYaw = LogicHandler.calculateBodyRot(Mth.rotLerp((float)delta, (float)living.yBodyRotO, (float)living.yBodyRot), EntityUtil.getYRot((Entity)player));
                        }
                    }
                    bodyOffset = 0.2f + (float)this.fpm.getConfig().sitXOffset / 100.0f;
                } else {
                    bodyOffset = 0.25f + (float)this.fpm.getConfig().xOffset / 100.0f;
                }
                x += (double)bodyOffset * Math.sin(Math.toRadians(realYaw));
                z -= (double)bodyOffset * Math.cos(Math.toRadians(realYaw));
                if (this.isCrawlingOrSwimming((Player)this.client.player)) {
                    y = player.xRotO > 0.0f && player.isUnderWater() ? (y += (double)0.6f * Math.sin(Math.toRadians(player.xRotO))) : (y += (double)0.01f * -Math.sin(Math.toRadians(player.xRotO)));
                }
            }
        }
        this.offset = new Vec3(x, y, z);
        for (PlayerOffsetHandler handler : FirstPersonAPI.getPlayerOffsetHandlers()) {
            this.offset = handler.applyOffset((AbstractClientPlayer)this.client.player, delta, Vec3.ZERO, this.offset);
        }
    }

    private static float calculateBodyRot(float entityBodyRot, float riderHeadRot) {
        float wrappedHeadRot = Mth.wrapDegrees((float)riderHeadRot);
        float rotDiff = Mth.wrapDegrees((float)(wrappedHeadRot - entityBodyRot));
        if (Mth.abs((float)rotDiff) > 50.0f) {
            entityBodyRot = wrappedHeadRot - 50.0f * Math.signum(rotDiff);
        }
        entityBodyRot = Mth.wrapDegrees((float)entityBodyRot);
        return entityBodyRot;
    }

    public boolean isSwimming(Player player) {
        return player.isSwimming();
    }

    public boolean isCrawlingOrSwimming(Player player) {
        return player.isVisuallySwimming();
    }

    public boolean showVanillaHands() {
        return this.showVanillaHands((LivingEntity)this.client.player);
    }

    public boolean showVanillaHands(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.showVanillaHands(InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean showVanillaHands(ItemStack mainhand, ItemStack offhand) {
        return this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL_DOUBLE || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ITEMS && (!mainhand.isEmpty() || !offhand.isEmpty()) || this.autoVanillaHandItems.contains(mainhand.getItem()) || this.autoVanillaHandItems.contains(offhand.getItem()) || this.autoDisableItems.contains(mainhand.getItem()) || this.autoDisableItems.contains(offhand.getItem());
    }

    public boolean hideArmsAndItems() {
        return this.hideArmsAndItems((LivingEntity)this.client.player);
    }

    public boolean hideArmsAndItems(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.hideArmsAndItems(livingEntity, InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean hideArmsAndItems(LivingEntity livingEntity, ItemStack mainhand, ItemStack offhand) {
        Player player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof Player && this.isSwimming(player = (Player)livingEntity)) {
            return false;
        }
        if (this.lookingDown()) {
            return false;
        }
        return this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF || this.autoVanillaHandItems.contains(mainhand.getItem()) || this.autoVanillaHandItems.contains(offhand.getItem()) || this.autoDisableItems.contains(mainhand.getItem()) || this.autoDisableItems.contains(offhand.getItem());
    }

    public boolean dynamicHandsEnabled() {
        return this.dynamicHandsEnabled((LivingEntity)this.client.player);
    }

    public boolean dynamicHandsEnabled(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.dynamicHandsEnabled(livingEntity, InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean dynamicHandsEnabled(LivingEntity livingEntity, ItemStack mainhand, ItemStack offhand) {
        Player player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof Player && this.isSwimming(player = (Player)livingEntity)) {
            return false;
        }
        return this.fpm.getConfig().dynamicMode && this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF && !this.autoVanillaHandItems.contains(mainhand.getItem()) && !this.autoVanillaHandItems.contains(offhand.getItem()) && !this.autoDisableItems.contains(mainhand.getItem()) && !this.autoDisableItems.contains(offhand.getItem());
    }

    public boolean lookingDown() {
        return this.lookingDown((LivingEntity)this.client.player);
    }

    public boolean lookingDown(LivingEntity livingEntity) {
        return this.dynamicHandsEnabled() && EntityUtil.getXRot((Entity)livingEntity) > 30.0f;
    }

    public boolean lookingDown(LivingEntityRenderState state) {
        return this.dynamicHandsEnabled() && state.xRot > 30.0f;
    }

    public void addAutoVanillaHandsItem(Item item) {
        this.autoVanillaHandItems.add(item);
    }

    public void addAutoDisableItem(Item item) {
        this.autoDisableItems.add(item);
    }

    public void reloadAutoVanillaHandsSettings() {
        Item item;
        this.autoVanillaHandItems.clear();
        this.autoDisableItems.clear();
        Item invalid = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)"minecraft", (String)"air"));
        for (String itemId : this.fpm.getConfig().autoVanillaHands) {
            try {
                item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)itemId.split(":")[0], (String)itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoVanillaHandsItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto vanilla hold list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Vanilla Hands items: {}", this.autoVanillaHandItems);
        for (String itemId : this.fpm.getConfig().autoToggleModItems) {
            try {
                item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)itemId.split(":")[0], (String)itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoDisableItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto disable list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Auto Disable items: {}", this.autoDisableItems);
    }

    @Generated
    public LogicHandler(Minecraft client, FirstPersonModelCore fpm) {
        this.client = client;
        this.fpm = fpm;
    }

    @Generated
    public Vec3 getOffset() {
        return this.offset;
    }
}

