/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.components.InvisButton;
import net.mudhut.ffpackage.registries.FFPCatalogTabs;
import net.mudhut.ffpackage.server.purchase.PurchaseSys;
import net.mudhut.ffpackage.util.CatalogPage;
import net.mudhut.ffpackage.util.CatalogTab;
import net.refractionapi.refraction.feature.scheme.RScreen;
import net.refractionapi.refraction.feature.scheme.RegisterScreen;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;

@RegisterScreen(value=PurchaseSys.class)
public class CatalogScreen
extends Screen
implements RScreen {
    public static final ResourceLocation CATALOG_BACKGROUND = FFPackage.resource("textures/gui/catalog_menu.png");
    public static final ResourceLocation CART_SPRITE = FFPackage.resource("catalog/catalog_cart_list");
    public static final HashMap<Integer, PurchaseSys.PurchasableItem> itemCatalog = PurchaseSys.items();
    private final List<Button> itemButtons = new ArrayList<Button>();
    private final List<Button> catalogTabButtons = new ArrayList<Button>();
    private final List<CatalogPage> pages = new ArrayList<CatalogPage>();
    private CatalogPage currentPage = new CatalogPage(new ArrayList<CatalogTab>());
    private static CatalogTab selectedTab = FFPCatalogTabs.BLOCK_TAB.get();
    public final Cart cart = new Cart();
    int msgTime = 0;
    Component msg = null;

    public CatalogScreen() {
        super((Component)Component.literal((String)"Purchase"));
    }

    protected void init() {
        super.init();
        Iterator catalogTabList = FFPCatalogTabs.CATALOG_TABS.getEntries().iterator();
        ArrayList currentPage = new ArrayList();
        int tabs = 0;
        while (catalogTabList.hasNext()) {
            if (++tabs != 5) continue;
            tabs = 0;
        }
        this.currentPage = this.pages.stream().filter(page -> page.visibleTabs.contains(selectedTab)).findFirst().orElse(this.currentPage);
        if (!this.currentPage.visibleTabs.contains(selectedTab)) {
            selectedTab = this.currentPage.visibleTabs.getFirst();
        }
        itemCatalog.forEach((id, item) -> this.itemButtons.add((Button)this.addRenderableWidget((GuiEventListener)InvisButton.builder((Component)Component.empty(), btn -> this.cart.addItem((int)id, 1)).pos(this.width / 2 - 115 + this.itemButtons.size() * 18, this.height / 2 - 86).size(18, 18).build())));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.width / 2 + 130, this.height / 2 + 24, 80, 19, new WidgetSprites(FFPackage.resource("catalog/cart_buy_button"), FFPackage.resource("catalog/cart_buy_button_selected")), btn -> this.sendNbt(this.cart.sendBuyRequest())));
    }

    public void tick() {
        super.tick();
        int n = this.msgTime = this.msg == null ? 0 : (this.msgTime = this.msgTime + 1);
        this.msg = this.msg != null ? (this.msgTime < 40 ? this.msg : null) : null;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        Iterator<Map.Entry<Integer, Integer>> it = this.cart.items.entrySet().iterator();
        int i = 0;
        if (this.msg != null) {
            guiGraphics.drawString(this.font, this.msg, this.width / 2 + 130, this.height / 2 - 116, Color.BLACK.getRGB(), false);
        }
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            int id = entry.getKey();
            int count = entry.getValue();
            PurchaseSys.PurchasableItem item = this.cart.get(id);
            String itemName = item.name();
            guiGraphics.drawString(this.font, "%s".formatted(count), this.width / 2 + 132, this.height / 2 - 86 + i * 9, Color.BLACK.getRGB(), false);
            if (itemName.length() > 15) {
                itemName = "%s".formatted(itemName.substring(0, 15) + "...");
            }
            guiGraphics.drawString(this.font, itemName, this.width / 2 + 146, this.height / 2 - 86 + i * 9, Color.BLACK.getRGB(), false);
            ++i;
        }
        guiGraphics.drawString(this.font, "Total: $%s".formatted(this.cart.totalPrice()), this.width / 2 + 146, this.height / 2 - 105, Color.BLACK.getRGB(), false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(CART_SPRITE, (this.width + 232) / 2, (this.height - 239) / 2, 123, 165);
        guiGraphics.blit(CATALOG_BACKGROUND, (this.width - 255) / 2, (this.height - 255) / 2, 0, 0, 256, 197);
    }

    public void handle(ScreenScheme.ScreenMessage screenMessage) {
        CompoundTag compoundTag = screenMessage.tag();
        if (!compoundTag.contains("response") || this.getMinecraft().level == null) {
            return;
        }
        this.msg = Component.Serializer.fromJson((String)compoundTag.getString("response"), (HolderLookup.Provider)this.getMinecraft().level.registryAccess());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static class Cart {
        public final HashMap<Integer, Integer> items = new HashMap();

        public boolean validCount(int count) {
            return count > 0 && count < 256;
        }

        public void addItem(int item, int added) {
            if (!this.validCount(added)) {
                return;
            }
            this.items.compute(item, (count, oldCount) -> {
                int ret = oldCount == null ? added : Math.clamp((long)(oldCount + added), 0, 45);
                return ret == 0 ? null : Integer.valueOf(ret);
            });
        }

        public int totalPrice() {
            return this.items.entrySet().stream().mapToInt(entry -> {
                PurchaseSys.PurchasableItem item = this.get((Integer)entry.getKey());
                return item == null ? 0 : item.price() * (Integer)entry.getValue();
            }).sum();
        }

        public CompoundTag compileCart() {
            CompoundTag tag = new CompoundTag();
            ListTag tags = new ListTag();
            this.items.forEach((id, count) -> {
                CompoundTag purchasable = new CompoundTag();
                purchasable.putInt("id", id.intValue());
                purchasable.putInt("count", count.intValue());
                tags.add((Object)purchasable);
            });
            tag.put("items", (Tag)tags);
            return tag;
        }

        public CompoundTag sendBuyRequest() {
            CompoundTag cart = this.compileCart();
            this.items.clear();
            return cart;
        }

        public PurchaseSys.PurchasableItem get(int item) {
            return itemCatalog.get(item);
        }
    }
}

