/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.gui.main_menu;

import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.lang.invoke.LambdaMetafactory;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommonButtons;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.gui.main_menu.FFPModListScreen;
import net.mudhut.ffpackage.client.gui.main_menu.FFPMultiplayerScreen;
import net.mudhut.ffpackage.client.gui.main_menu.FFPOptionsScreen;
import net.mudhut.ffpackage.client.gui.main_menu.FFPRealmsScreen;
import net.mudhut.ffpackage.client.gui.main_menu.FFPSelectWorldScreen;
import net.mudhut.ffpackage.registries.FFPSounds;
import net.neoforged.neoforge.client.gui.widget.ModsButton;

public class FFPTitleScreen
extends Screen {
    private static final ResourceLocation SCROLLING_LINE = FFPackage.resource("blips/scrolling_line");
    private static final Component COPYRIGHT_TEXT = Component.translatable((String)"title.credits");
    private final LogoRenderer logoRenderer;
    private SplashRenderer splash;
    private RealmsNotificationsScreen realmsNotificationsScreen;
    private final int BUTTON_OFFSET;
    private final int BUTTON_OFFSET_LEFT;
    private final int LOGO_OFFSET_LEFT;
    private final int LOGO_OFFSET;
    public int lineScroll;
    public int staticFrame;
    public int blipFrame;
    public int fredPose;
    public int poseTick;
    public int blipTick;
    public static final ResourceLocation[] BLIPS = new ResourceLocation[]{FFPackage.resource("blips/blip_0"), FFPackage.resource("blips/blip_1"), FFPackage.resource("blips/blip_2"), FFPackage.resource("blips/blip_3"), FFPackage.resource("blips/blip_4"), FFPackage.resource("blips/blip_5"), FFPackage.resource("blips/blip_6"), FFPackage.resource("blips/blip_7"), FFPackage.resource("blips/blip_8")};
    public static final ResourceLocation[] FREDDY_BACKGROUND = new ResourceLocation[]{FFPackage.resource("main_menu/freddy_background_1"), FFPackage.resource("main_menu/freddy_background_2"), FFPackage.resource("main_menu/freddy_background_3"), FFPackage.resource("main_menu/freddy_background_4")};
    public static final ResourceLocation[] STATIC_OVERLAY = new ResourceLocation[]{FFPackage.resource("static/static_0"), FFPackage.resource("static/static_1"), FFPackage.resource("static/static_2"), FFPackage.resource("static/static_3"), FFPackage.resource("static/static_4"), FFPackage.resource("static/static_5"), FFPackage.resource("static/static_6")};

    public FFPTitleScreen() {
        super((Component)Component.translatable((String)"narrator.screen.title"));
        this.BUTTON_OFFSET = this.width / 2 - 100;
        this.BUTTON_OFFSET_LEFT = this.width / 25;
        this.LOGO_OFFSET_LEFT = this.width / 25 + 260;
        this.LOGO_OFFSET = this.width;
        this.lineScroll = 0;
        this.staticFrame = 0;
        this.blipFrame = 0;
        this.fredPose = 0;
        this.poseTick = 0;
        this.blipTick = 0;
        this.logoRenderer = new LogoRenderer(false);
    }

    private boolean realmsNotificationsEnabled() {
        return this.realmsNotificationsScreen != null;
    }

    public void tick() {
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.tick();
        }
    }

    protected void init() {
        if (this.minecraft != null) {
            if (this.splash == null) {
                this.splash = this.minecraft.getSplashManager().getSplash();
            }
            int copyrightWidth = this.font.width((FormattedText)COPYRIGHT_TEXT);
            int titleWidth = this.font.width((FormattedText)Component.translatable((String)"ffpackage.title.mod_name"));
            int j = this.width - copyrightWidth;
            int m = this.width - titleWidth - 2;
            int l = this.height / 4 + 32;
            this.createNormalMenuOptions(l, 24);
            this.addRenderableWidget((GuiEventListener)new ModsButton(Button.builder((Component)Component.translatable((String)"fml.menu.mods"), onPress -> this.minecraft.setScreen((Screen)new FFPModListScreen(this))).pos(this.width / 2 - 100, l + 72).size(200, 20)));
            SpriteIconButton spriteiconbutton = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.language((int)20, onPress -> this.minecraft.setScreen((Screen)new LanguageSelectScreen((Screen)this, this.minecraft.options, this.minecraft.getLanguageManager())), (boolean)true));
            spriteiconbutton.setPosition(this.width / 150, this.height - 22);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.options"), onPress -> this.minecraft.setScreen((Screen)new FFPOptionsScreen(this, this.minecraft.options))).bounds(this.width / 2 - 100, (l += 22) + 72 + 12, 98, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.quit"), onPress -> this.minecraft.stop()).bounds(this.width / 2 - 100 + 102, l + 72 + 12, 98, 20).build());
            SpriteIconButton spriteiconbutton1 = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.accessibility((int)20, onPress -> this.minecraft.setScreen((Screen)new AccessibilityOptionsScreen((Screen)this, this.minecraft.options)), (boolean)true));
            spriteiconbutton1.setPosition(this.width / 150 + 22, this.height - 22);
            this.addRenderableWidget((GuiEventListener)new PlainTextButton(j, this.height - 10, copyrightWidth, 10, COPYRIGHT_TEXT, onPress -> this.minecraft.setScreen((Screen)new CreditsAndAttributionScreen((Screen)this)), this.font));
            this.addRenderableWidget((GuiEventListener)new PlainTextButton(m - this.width + 203, this.height / 100, titleWidth, 10, (Component)Component.translatable((String)"ffpackage.title.mod_name"), p_280834_ -> this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(FFPSounds.HONK, (float)1.0f)), this.font));
            if (this.realmsNotificationsScreen == null) {
                this.realmsNotificationsScreen = new RealmsNotificationsScreen();
            }
            this.realmsNotificationsScreen.init(this.minecraft, this.width, this.height);
        }
    }

    private void createNormalMenuOptions(int y, int rowHeight) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.singleplayer"), onPress -> this.minecraft.setScreen((Screen)new FFPSelectWorldScreen(this))).bounds(this.width / 2 - 100, y, 200, 20).build());
        Component component = this.getMultiplayerDisabledReason();
        boolean flag = component == null;
        Tooltip tooltip = component != null ? Tooltip.create((Component)component) : null;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.multiplayer"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$8(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((FFPTitleScreen)this)).bounds((int)(this.width / 2 - 100), (int)(y + rowHeight), (int)200, (int)20).tooltip((Tooltip)tooltip).build())).active = flag;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.online"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$9(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((FFPTitleScreen)this)).bounds((int)(this.width / 2 - 100), (int)(y + rowHeight * 2), (int)200, (int)20).tooltip((Tooltip)tooltip).build())).active = flag;
    }

    @Nullable
    private Component getMultiplayerDisabledReason() {
        if (this.minecraft.allowsMultiplayer()) {
            return null;
        }
        if (this.minecraft.isNameBanned()) {
            return Component.translatable((String)"title.multiplayer.disabled.banned.name");
        }
        BanDetails bandetails = this.minecraft.multiplayerBan();
        if (bandetails != null) {
            return bandetails.expires() != null ? Component.translatable((String)"title.multiplayer.disabled.banned.temporary") : Component.translatable((String)"title.multiplayer.disabled.banned.permanent");
        }
        return Component.translatable((String)"title.multiplayer.disabled");
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RandomSource random = RandomSource.create();
        this.logoRenderer.renderLogo(guiGraphics, this.width, 1.0f);
        this.staticFrame = this.staticFrame + 1 == STATIC_OVERLAY.length ? 0 : this.staticFrame + 1;
        ++this.poseTick;
        ++this.blipTick;
        ++this.lineScroll;
        this.baseBackground(guiGraphics, this.width, this.height);
        if (this.lineScroll > this.height * 2) {
            this.lineScroll = -55;
        }
        if (random.nextInt(290) == 0) {
            this.fredPose = random.nextInt(1, 3);
            this.poseTick = 0;
        }
        if (random.nextInt(50) == 0) {
            this.blipFrame = random.nextInt(1, 8);
        }
        if (this.blipTick >= 20) {
            this.blipFrame = 0;
            this.blipTick = 0;
        }
        if (this.poseTick >= 6) {
            this.fredPose = 0;
        }
        this.logoRenderer.renderLogo(guiGraphics, this.width, 1.0f);
        int i = Mth.ceil((float)255.0f) << 24;
        if (this.minecraft != null && (i & 0xFC000000) != 0 && this.splash != null && !((Boolean)this.minecraft.options.hideSplashTexts().get()).booleanValue()) {
            this.splash.render(guiGraphics, this.width, this.font, i);
        }
    }

    public void baseBackground(GuiGraphics guiGraphics, int width, int height) {
        guiGraphics.blitSprite(FREDDY_BACKGROUND[this.fredPose], 0, 0, width, height);
        RenderSystem.enableBlend();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blitSprite(SCROLLING_LINE, 0, this.lineScroll / 2, width, 20);
        guiGraphics.blitSprite(BLIPS[this.blipFrame], 0, 0, width, height);
        guiGraphics.blitSprite(STATIC_OVERLAY[this.staticFrame], 0, 0, width, height);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$9(Button onPress) {
        this.minecraft.setScreen((Screen)new FFPRealmsScreen(this));
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$8(Button onPress) {
        FFPMultiplayerScreen screen = this.minecraft.options.skipMultiplayerWarning ? new FFPMultiplayerScreen(this) : new SafetyScreen((Screen)this);
        this.minecraft.setScreen((Screen)screen);
    }
}

