/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.client.FFPModelLayers;
import net.mudhut.ffpackage.client.model.Endo01Model;
import net.mudhut.ffpackage.client.model.suit.AnimatronicClassicSuitModel;
import net.mudhut.ffpackage.client.model.suit.ClassicBonnieModel;
import net.mudhut.ffpackage.client.model.suit.ClassicChicaModel;
import net.mudhut.ffpackage.client.model.suit.ClassicFoxyModel;
import net.mudhut.ffpackage.client.model.suit.ClassicFreddyModel;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.item.PlushSuitItem;
import net.mudhut.ffpackage.registries.FFPTagsRegistry;

public class EndoSuitLayer
extends RenderLayer<Endo01, Endo01Model<Endo01>> {
    private AnimatronicClassicSuitModel<Endo01> suitModel;

    public EndoSuitLayer(RenderLayerParent<Endo01, Endo01Model<Endo01>> renderer, EntityModelSet entityModelSet) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, Endo01 endo01, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderSuitPiece(poseStack, multiBufferSource, endo01, EquipmentSlot.HEAD, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderSuitPiece(poseStack, multiBufferSource, endo01, EquipmentSlot.CHEST, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderSuitPiece(poseStack, multiBufferSource, endo01, EquipmentSlot.LEGS, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderSuitPiece(poseStack, multiBufferSource, endo01, EquipmentSlot.FEET, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    private void renderSuitPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, Endo01 endo01, EquipmentSlot slot, int packedLight, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        PlushSuitItem plushSuitItem;
        ItemStack itemStack = endo01.getItemBySlot(slot);
        Item item = itemStack.getItem();
        if (item instanceof PlushSuitItem && (plushSuitItem = (PlushSuitItem)item).getEquipmentSlot() == slot) {
            this.suitModel = itemStack.is(FFPTagsRegistry.CLASSIC_FREDDY) ? new ClassicFreddyModel<Endo01>(Minecraft.getInstance().getEntityModels().bakeLayer(FFPModelLayers.CLASSIC_FREDDY)) : (itemStack.is(FFPTagsRegistry.CLASSIC_BONNIE) ? new ClassicBonnieModel<Endo01>(Minecraft.getInstance().getEntityModels().bakeLayer(FFPModelLayers.CLASSIC_BONNIE)) : (itemStack.is(FFPTagsRegistry.CLASSIC_CHICA) ? new ClassicChicaModel<Endo01>(Minecraft.getInstance().getEntityModels().bakeLayer(FFPModelLayers.CLASSIC_CHICA)) : new ClassicFoxyModel<Endo01>(Minecraft.getInstance().getEntityModels().bakeLayer(FFPModelLayers.CLASSIC_FOXY))));
            this.setPartVisibility(this.suitModel, slot);
            ((Endo01Model)this.getParentModel()).copyPropertiesTo((EntityModel)this.suitModel);
            this.suitModel.setupAnim(endo01, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ArmorMaterial armormaterial = (ArmorMaterial)plushSuitItem.getMaterial().value();
            for (int layerIdx = 0; layerIdx < armormaterial.layers().size(); ++layerIdx) {
                ArmorMaterial.Layer armormaterial$layer = (ArmorMaterial.Layer)armormaterial.layers().get(layerIdx);
                ResourceLocation texture = plushSuitItem.getArmorTexture(itemStack, (Entity)endo01, slot, armormaterial$layer, false);
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texture));
                this.suitModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, new Color(255, 255, 255).getRGB());
            }
        }
    }

    protected void setPartVisibility(AnimatronicClassicSuitModel<Endo01> model, EquipmentSlot slot) {
        model.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                model.Torso.visible = true;
                model.Torso.skipDraw = true;
                model.Head.visible = true;
                model.Jaw.visible = true;
                model.LeftEar.visible = true;
                model.RightEar.visible = true;
                break;
            }
            case CHEST: {
                model.Torso.visible = true;
                model.RightArm.visible = true;
                model.LeftArm.visible = true;
                break;
            }
            case LEGS: {
                model.RightLeg.visible = true;
                model.LeftLeg.visible = true;
                break;
            }
            case FEET: {
                model.RightLeg.visible = true;
                model.LeftLeg.visible = true;
                model.RightLeg.skipDraw = true;
                model.LeftLeg.skipDraw = true;
                model.LowerLeftLeg.visible = true;
                model.LowerRightLeg.visible = true;
            }
        }
    }
}

