/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.mudhut.ffpackage.client.animation.Endo01Animations;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.registries.FFPItemRegistry;

public class Endo01Model<T extends Endo01>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart Root;
    private final ModelPart RightLeg;
    private final ModelPart LowerRightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart LowerLeftLeg;
    private final ModelPart Torso;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart LeftEar;
    private final ModelPart RightEar;

    public Endo01Model(ModelPart root) {
        this.Root = root.getChild("Root");
        this.RightLeg = this.Root.getChild("RightLeg");
        this.LowerRightLeg = this.RightLeg.getChild("LowerRightLeg");
        this.LeftLeg = this.Root.getChild("LeftLeg");
        this.LowerLeftLeg = this.LeftLeg.getChild("LowerLeftLeg");
        this.Torso = this.Root.getChild("Torso");
        this.LeftArm = this.Torso.getChild("LeftArm");
        this.RightArm = this.Torso.getChild("RightArm");
        this.Head = this.Torso.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.RightEar = this.Head.getChild("RightEar");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Root = partdefinition.addOrReplaceChild("Root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition RightLeg = Root.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(24, 30).addBox(-1.0f, -1.05f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(36, 47).addBox(-3.0f, -1.05f, 0.0f, 6.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)0.0f));
        PartDefinition LowerRightLeg = RightLeg.addOrReplaceChild("LowerRightLeg", CubeListBuilder.create().texOffs(24, 24).addBox(-4.0f, 0.05f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)13.925f, (float)0.0f));
        PartDefinition LeftLeg = Root.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 30).addBox(-1.0f, -1.05f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 47).addBox(-3.0f, -1.05f, 0.0f, 6.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)0.0f));
        PartDefinition LowerLeftLeg = LeftLeg.addOrReplaceChild("LowerLeftLeg", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, 0.05f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)13.925f, (float)0.0f));
        PartDefinition Torso = Root.addOrReplaceChild("Torso", CubeListBuilder.create().texOffs(16, 35).addBox(-1.0f, -15.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(-0.01f)).texOffs(56, 33).addBox(-1.0f, -15.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(0, 0).addBox(-7.0f, -17.0f, 0.025f, 14.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(28, 14).addBox(-3.0f, -1.025f, -1.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)).texOffs(0, 20).addBox(-7.0f, -13.0f, -1.0f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition LeftArm = Torso.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -1.05f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 45).addBox(1.0f, -1.05f, -2.0f, 0.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)-11.0f, (float)0.0f));
        PartDefinition RightArm = Torso.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(8, 35).addBox(-2.0f, -1.05f, -1.0f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(56, 45).addBox(-1.0f, -1.05f, -2.0f, 0.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)-11.0f, (float)0.0f));
        PartDefinition Head = Torso.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(46, 10).addBox(-3.0f, -1.0f, -1.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(28, 6).addBox(-4.0f, -8.0f, -1.0f, 8.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(46, 18).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-6.0f, -10.0f, 0.0f, 12.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(40, 30).addBox(1.0f, -6.0f, -4.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(40, 36).addBox(-4.0f, -6.0f, -4.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(32, 19).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(44, 14).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(40, 42).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(46, 6).addBox(-2.0f, -1.0f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-8.0f, (float)0.0f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Endo01 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netheadYaw, float headPitch) {
        boolean feetVisibility;
        this.Root.getAllParts().forEach(ModelPart::resetPose);
        if (entity.getCurrentPose() != 2) {
            if (entity.getMainHandItem().is(FFPItemRegistry.CLASSIC_GUITAR)) {
                this.RightArm.xRot = -0.75f;
                this.LeftArm.setRotation(-0.5f, 0.0f, 0.0f);
            }
            if (entity.getOffhandItem().is(FFPItemRegistry.CLASSIC_GUITAR)) {
                this.LeftArm.xRot = -0.75f;
                this.LeftArm.yRot = 0.3f;
            }
        }
        boolean flag = entity.isPossessed() && entity.level().isNight();
        this.RightArm.visible = !entity.getItemBySlot(EquipmentSlot.CHEST).is(FFPItemRegistry.FOXY_SUIT_TORSO);
        this.LowerLeftLeg.visible = feetVisibility = !entity.getItemBySlot(EquipmentSlot.FEET).is(FFPItemRegistry.FOXY_SUIT_FEET) && !entity.getItemBySlot(EquipmentSlot.FEET).is(FFPItemRegistry.CHICA_SUIT_FEET);
        this.LowerRightLeg.visible = feetVisibility;
        if (flag) {
            this.Head.yRot = netheadYaw * ((float)Math.PI / 180);
            this.Head.xRot = headPitch * ((float)Math.PI / 180);
        }
        this.animate(entity.jumpscareState, Endo01Animations.JUMPSCARE, ageInTicks);
        this.animate(entity.attackState, Endo01Animations.ATTACK, ageInTicks);
        this.animate(entity.idleState, flag ? Endo01Animations.POSSESSED_IDLE : Endo01Animations.IDLE, ageInTicks);
        this.animateWalk(entity.isAggressive() ? Endo01Animations.CHASE : Endo01Animations.WALK, limbSwing, limbSwingAmount, 2.0f, 1.5f);
        this.animate(entity.danceState, Endo01Animations.DAISY_BELL_DANCE, ageInTicks);
        this.animate(entity.crouchState, Endo01Animations.CROUCH, ageInTicks);
        this.animate(entity.possessionState, Endo01Animations.POSSESSION, ageInTicks);
        this.animate(entity.pose1, Endo01Animations.POSE1, ageInTicks);
        this.animate(entity.pose2, Endo01Animations.POSE2, ageInTicks);
        this.animate(entity.pose3, Endo01Animations.POSE3, ageInTicks);
        if (entity.getCurrentPose() == 0) {
            if (entity.getMainHandItem().is(FFPItemRegistry.CLASSIC_MR_CUPCAKE)) {
                this.RightArm.xRot = -1.3f;
                this.RightArm.yRot = 0.15f;
            }
            if (entity.getOffhandItem().is(FFPItemRegistry.CLASSIC_MR_CUPCAKE)) {
                this.LeftArm.xRot = -1.3f;
                this.LeftArm.yRot = -0.15f;
            }
        }
        if (entity.getCurrentPose() != 2) {
            if (entity.getMainHandItem().is(FFPItemRegistry.CLASSIC_MICROPHONE)) {
                this.RightArm.xRot = -0.75f;
                this.RightArm.yRot = -0.3f;
            }
            if (entity.getOffhandItem().is(FFPItemRegistry.CLASSIC_MICROPHONE)) {
                this.LeftArm.xRot = -0.75f;
                this.LeftArm.yRot = 0.3f;
            }
        }
    }

    public ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public void translateToHand(HumanoidArm side, PoseStack poseStack) {
        ModelPart modelpart = this.getArm(side);
        poseStack.translate(0.0, 0.75, 0.0);
        modelpart.translateAndRotate(poseStack);
    }

    public ModelPart root() {
        return this.Root;
    }

    public void setAllVisible(boolean visible) {
        this.Torso.visible = visible;
        this.LeftArm.visible = visible;
        this.RightArm.visible = visible;
        this.Head.visible = visible;
        this.Jaw.visible = visible;
        this.RightEar.visible = visible;
        this.LeftEar.visible = visible;
        this.RightLeg.visible = visible;
        this.LeftLeg.visible = visible;
    }
}

