/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.client.FFPModelLayers;
import net.mudhut.ffpackage.level.block.VintageSpotlightBlock;
import net.mudhut.ffpackage.level.block.entity.VintageSpotlightBlockEntity;

public class VintageSpotlightRenderer
implements BlockEntityRenderer<VintageSpotlightBlockEntity> {
    public static final ResourceLocation SPOTLIGHT_LIGHT = FFPackage.resource("textures/entity/vintage_spotlight_layer.png");
    public static final RenderType RENDER_TYPE = RenderType.entityTranslucentEmissive((ResourceLocation)SPOTLIGHT_LIGHT);
    public ModelPart base;

    public VintageSpotlightRenderer(BlockEntityRendererProvider.Context context) {
        this.base = context.bakeLayer(FFPModelLayers.VINTAGE_SPOTLIGHT);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cube = partdefinition.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -6.0f, 0.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)1.6f, (float)-3.95f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(VintageSpotlightBlockEntity vintageSpotlightBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        BlockState block = vintageSpotlightBlockEntity.getBlockState();
        if (!((Boolean)block.getValue((Property)VintageSpotlightBlock.LIT)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - ((Direction)vintageSpotlightBlockEntity.getBlockState().getValue((Property)VintageSpotlightBlock.FACING)).toYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees((Boolean)block.getValue((Property)VintageSpotlightBlock.HANGING) != false ? -22.5f : 22.5f));
        if (((Boolean)block.getValue((Property)VintageSpotlightBlock.HANGING)).booleanValue()) {
            this.base.setPos(0.0f, 2.8f, 0.0f);
        } else {
            this.base.setPos(0.0f, 0.0f, 0.0f);
        }
        this.base.render(poseStack, multiBufferSource.getBuffer(RENDER_TYPE), packedLight, packedOverlay, vintageSpotlightBlockEntity.colorId);
        poseStack.popPose();
    }
}

