/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.mudhut.ffpackage.datagen.FFPBlockStateProvider;
import net.mudhut.ffpackage.datagen.FFPDataPackProviders;
import net.mudhut.ffpackage.datagen.FFPItemModelProvider;
import net.mudhut.ffpackage.datagen.FFPLanguageProvider;
import net.mudhut.ffpackage.datagen.FFPRecipeProvider;
import net.mudhut.ffpackage.datagen.FFPSoundProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ffpackage", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        dataGenerator.addProvider(true, (DataProvider)new FFPRecipeProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(true, (DataProvider)new FFPBlockStateProvider(packOutput, existingFileHelper));
        dataGenerator.addProvider(true, (DataProvider)new FFPItemModelProvider(packOutput, existingFileHelper));
        dataGenerator.addProvider(true, (DataProvider)new FFPLanguageProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)new FFPSoundProvider(packOutput, existingFileHelper));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new FFPDataPackProviders(packOutput, lookupProvider));
    }
}

