/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.CurtainBlock;
import net.mudhut.ffpackage.level.block.FluorescentLampBlock;
import net.mudhut.ffpackage.level.block.MangroveDoorCollisionBlock;
import net.mudhut.ffpackage.level.block.MangroveEntranceDoorBlock;
import net.mudhut.ffpackage.level.block.PartyHatBlock;
import net.mudhut.ffpackage.level.block.PizzaBlock;
import net.mudhut.ffpackage.level.block.ShowtapePlayerBlock;
import net.mudhut.ffpackage.level.block.TomatoBushBlock;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPPizzeriaBlocks;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FFPBlockStateProvider
extends BlockStateProvider {
    public FFPBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ffpackage", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder registry : FFPBlockRegistry.BLOCKS.getEntries()) {
            if (registry.get() instanceof TomatoBushBlock || registry.get() instanceof PizzaBlock || registry.get() instanceof ShowtapePlayerBlock) continue;
            this.blockWithItem((DeferredBlock<Block>)((DeferredBlock)registry));
        }
        for (DeferredHolder registry : FFPPizzeriaBlocks.BLOCKS.getEntries()) {
            if (registry.get() instanceof StairBlock || registry.get() instanceof MangroveEntranceDoorBlock || registry.get() instanceof SlabBlock || registry.get() instanceof FluorescentLampBlock || registry.get() instanceof MangroveDoorCollisionBlock || registry.is(FFPPizzeriaBlocks.BLACK_STAGE) || registry.is(FFPPizzeriaBlocks.BLACK_CHECKER_TRIM) || registry.is(FFPPizzeriaBlocks.RED_CHECKER_TRIM)) continue;
            if (registry.get() instanceof CurtainBlock) {
                this.horizontalBlockWithItem((DeferredBlock<Block>)((DeferredBlock)registry), false);
                continue;
            }
            if (registry.get() instanceof RedstoneLampBlock) {
                this.lampBlock((DeferredBlock<Block>)((DeferredBlock)registry));
                continue;
            }
            this.blockWithItem((DeferredBlock<Block>)((DeferredBlock)registry));
        }
        for (DeferredHolder registry : FFPDecorBlockRegistry.BLOCKS.getEntries()) {
            if (!(registry.get() instanceof PartyHatBlock)) continue;
            this.crossBlock((DeferredBlock<Block>)((DeferredBlock)registry));
        }
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.FREDDY_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.BONNIE_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.CHICA_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.FOXY_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.CELEBRATE_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.PARTY_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.RULES_POSTER, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.STARRED_BLACK_CHAIR, true);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.HANGING_STARS, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.STARS_CHAIN, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.WOOD_CLOUD_CHAIN, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.WOOD_SUN, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.WOOD_CLOUD, false);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.STAGE_SPEAKER, true);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.SODA_MACHINE, true);
        this.horizontalBlockWithItem(FFPDecorBlockRegistry.MM_MACHINE, true);
        this.horizontalBlockWithItem(FFPBlockRegistry.SHOWTAPE_PLAYER, true);
        this.horizontalBlockWithItem(FFPPizzeriaBlocks.MANGROVE_ENTRANCE_DOOR_COLLISION, false);
        this.sidedBlock(FFPPizzeriaBlocks.BLACK_STAGE, FFPackage.resource("block/black_stage_side"), FFPackage.resource("block/black_stage_top"), FFPackage.resource("block/black_stage_top"));
        this.sidedBlock(FFPPizzeriaBlocks.BLACK_CHECKER_TRIM, FFPackage.resource("block/black_checker_trim"), FFPackage.resource("block/concrete"), FFPackage.resource("block/concrete"));
        this.sidedBlock(FFPPizzeriaBlocks.RED_CHECKER_TRIM, FFPackage.resource("block/red_checker_trim"), FFPackage.resource("block/concrete"), FFPackage.resource("block/concrete"));
        this.stairBlock(FFPPizzeriaBlocks.WHITE_TILE_STAIRS, FFPPizzeriaBlocks.WHITE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.WHITE_TILE_SLAB, FFPPizzeriaBlocks.WHITE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.BLACK_WHITE_TILE_STAIRS, FFPPizzeriaBlocks.BLACK_WHITE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.BLACK_WHITE_TILE_SLAB, FFPPizzeriaBlocks.BLACK_WHITE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.BLUE_BLACK_TILE_STAIRS, FFPPizzeriaBlocks.BLUE_BLACK_TILES);
        this.slabBlock(FFPPizzeriaBlocks.BLUE_BLACK_TILE_SLAB, FFPPizzeriaBlocks.BLUE_BLACK_TILES);
        this.stairBlock(FFPPizzeriaBlocks.BLUE_WHITE_TILE_STAIRS, FFPPizzeriaBlocks.BLUE_WHITE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.BLUE_WHITE_TILE_SLAB, FFPPizzeriaBlocks.BLUE_WHITE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.GREEN_BLACK_TILE_STAIRS, FFPPizzeriaBlocks.GREEN_BLACK_TILES);
        this.slabBlock(FFPPizzeriaBlocks.GREEN_BLACK_TILE_SLAB, FFPPizzeriaBlocks.GREEN_BLACK_TILES);
        this.stairBlock(FFPPizzeriaBlocks.GREEN_WHITE_TILE_STAIRS, FFPPizzeriaBlocks.GREEN_WHITE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.GREEN_WHITE_TILE_SLAB, FFPPizzeriaBlocks.GREEN_WHITE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.RED_BLACK_TILE_STAIRS, FFPPizzeriaBlocks.RED_BLACK_TILES);
        this.slabBlock(FFPPizzeriaBlocks.RED_BLACK_TILE_SLAB, FFPPizzeriaBlocks.RED_BLACK_TILES);
        this.stairBlock(FFPPizzeriaBlocks.RED_WHITE_TILE_STAIRS, FFPPizzeriaBlocks.RED_WHITE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.RED_WHITE_TILE_SLAB, FFPPizzeriaBlocks.RED_WHITE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.RED_BLUE_TILE_STAIRS, FFPPizzeriaBlocks.RED_BLUE_TILES);
        this.slabBlock(FFPPizzeriaBlocks.RED_BLUE_TILE_SLAB, FFPPizzeriaBlocks.RED_BLUE_TILES);
        this.stairBlock(FFPPizzeriaBlocks.YELLOW_GRAY_TILE_STAIRS, FFPPizzeriaBlocks.YELLOW_GRAY_TILES);
        this.slabBlock(FFPPizzeriaBlocks.YELLOW_GRAY_TILE_SLAB, FFPPizzeriaBlocks.YELLOW_GRAY_TILES);
        this.stairBlock(FFPPizzeriaBlocks.CONCRETE_STAIRS, FFPPizzeriaBlocks.CONCRETE);
        this.slabBlock(FFPPizzeriaBlocks.CONCRETE_SLAB, FFPPizzeriaBlocks.CONCRETE);
        this.stairBlock(FFPPizzeriaBlocks.MOSAIC_TILE_STAIRS, FFPPizzeriaBlocks.MOSAIC_TILES);
        this.slabBlock(FFPPizzeriaBlocks.MOSAIC_TILE_SLAB, FFPPizzeriaBlocks.MOSAIC_TILES);
    }

    private void stairBlock(DeferredBlock<Block> block, DeferredBlock<Block> ogBlock) {
        this.stairsBlock((StairBlock)block.get(), FFPackage.resource("block/" + ogBlock.getId().getPath()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getId().getPath()), this.models().existingFileHelper));
    }

    private void sidedBlock(DeferredBlock<Block> block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)this.models().cubeBottomTop(block.getId().getPath(), side, bottom, top));
    }

    private void slabBlock(DeferredBlock<Block> block, DeferredBlock<Block> ogBlock) {
        this.slabBlock((SlabBlock)block.get(), FFPackage.resource("block/" + ogBlock.getId().getPath()), FFPackage.resource("block/" + ogBlock.getId().getPath()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getId().getPath()), this.models().existingFileHelper));
    }

    private void horizontalBlockWithItem(DeferredBlock<Block> blockRegistryObject, boolean hasBlockItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile model = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "")), this.models().existingFileHelper);
        this.horizontalBlock(block, (ModelFile)model);
        if (hasBlockItem) {
            this.simpleBlockItem(block, (ModelFile)model);
        }
    }

    private void lampBlock(DeferredBlock<Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile litModel = this.cubeAll(block);
        ModelFile.ExistingModelFile unlitModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/stained_redstone_lamp_off"), this.models().existingFileHelper);
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean lit = (Boolean)state.getValue((Property)RedstoneTorchBlock.LIT);
            return ConfiguredModel.builder().modelFile((ModelFile)(lit ? litModel : unlitModel)).build();
        });
    }

    private void blockWithItem(DeferredBlock<Block> block) {
        this.simpleBlockWithItem((Block)block.get(), this.cubeAll((Block)block.get()));
    }

    private void existingModelBlock(DeferredBlock<Block> blockRegistryObject, boolean hasItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile modelFile = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "")), this.models().existingFileHelper);
        this.simpleBlock(block, (ModelFile)modelFile);
        if (hasItem) {
            this.simpleBlockItem(block, (ModelFile)modelFile);
        }
    }

    private void logRotationBlock(DeferredBlock<Block> blockRegistryObject, boolean hasItem) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile vertModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_vertical"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile horiModel = new ModelFile.ExistingModelFile(FFPackage.resource("block/" + block.getDescriptionId().replace("block.ffpackage.", "") + "_horizontal"), this.models().existingFileHelper);
        this.axisBlock((RotatedPillarBlock)block, (ModelFile)vertModel, (ModelFile)horiModel);
        if (hasItem) {
            this.simpleBlockItem(block, (ModelFile)vertModel);
        }
    }

    private void crossBlock(DeferredBlock<Block> block) {
        ModelBuilder cross = ((BlockModelBuilder)this.models().cross(block.getId().toString(), FFPackage.resource("block/" + ((Block)block.get()).getDescriptionId().replace("block.ffpackage.", "")))).renderType("minecraft:cutout");
        this.simpleBlock((Block)block.get(), (ModelFile)cross);
    }
}

